/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.culling;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.Frustum;
import net.minecraft.client.render.culling.FrustumData;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class CameraFrustum {
    @NotNull
    private final ICamera camera;
    @NotNull
    private final FrustumData frustum;

    public CameraFrustum(@NotNull ICamera camera) {
        this.camera = camera;
        this.frustum = Frustum.getFrustum();
    }

    public boolean cubeInFrustum(double x0, double y0, double z0, double x1, double y1, double z1, float partialTick) {
        return this.frustum.cubeInFrustum(x0 - this.camera.getX(partialTick), y0 - this.camera.getY(partialTick), z0 - this.camera.getZ(partialTick), x1 - this.camera.getX(partialTick), y1 - this.camera.getY(partialTick), z1 - this.camera.getZ(partialTick));
    }

    public boolean isVisible(@NotNull AABBdc aabb, float partialTick) {
        return this.cubeInFrustum(aabb.minX(), aabb.minY(), aabb.minZ(), aabb.maxX(), aabb.maxY(), aabb.maxZ(), partialTick);
    }
}

