/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class MobRenderer<T extends Mob>
extends EntityRenderer<T> {
    public static final float ENTITY_RENDER_SCALE = 16.0f;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final @NotNull List<@Nullable StaticEntityModel> setupModels = new ArrayList<StaticEntityModel>();

    public MobRenderer(float shadowSize) {
        super(shadowSize);
    }

    @Override
    public void render(@NotNull Tessellator tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        boolean hasOverlayAlpha;
        this.loadEntityTexture(entity);
        GL11.glEnable(32826);
        GL11.glBlendFunc(770, 771);
        GL11.glEnable(3042);
        GL11.glDisable(2884);
        GL11.glPushMatrix();
        this.preRenderTransform(entity, x, y, z, yaw, partialTick);
        float brightness = ((Entity)entity).getBrightness(partialTick);
        if (Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
        }
        this.setupModels.clear();
        int maxRenderLayer = this.maxRenderLayer(entity);
        for (int layer = 0; layer <= maxRenderLayer; ++layer) {
            try {
                StaticEntityModel model = this.getAndSetupModelForLayer(entity, brightness, partialTick, layer);
                this.setupModels.add(model);
                if (model == null) continue;
                model.render(tessellator);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error setting up model on layer '{}' in renderer '{}'", layer, this.getClass().getSimpleName(), e);
            }
        }
        this.renderAdditional(tessellator, entity, partialTick);
        GL11.glEnable(32826);
        int argb = this.getOverlayColor(entity, brightness, partialTick);
        boolean bl = hasOverlayAlpha = Color.alphaFromInt(argb) > 0;
        if (hasOverlayAlpha || ((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
            GL11.glDisable(3553);
            GL11.glDisable(3008);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDepthFunc(514);
            if (((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
                for (int layer = 0; layer <= maxRenderLayer; ++layer) {
                    StaticEntityModel model = this.setupModels.get(layer);
                    if (model == null) continue;
                    GL11.glColor4f(brightness, 0.0f, 0.0f, 0.4f);
                    model.render(tessellator);
                }
            }
            if (hasOverlayAlpha) {
                float r = (float)Color.redFromInt(argb) / 255.0f;
                float g = (float)Color.greenFromInt(argb) / 255.0f;
                float b = (float)Color.blueFromInt(argb) / 255.0f;
                float a = (float)Color.alphaFromInt(argb) / 255.0f;
                for (int layer = 0; layer < maxRenderLayer; ++layer) {
                    StaticEntityModel model = this.setupModels.get(layer);
                    if (model == null) continue;
                    GL11.glColor4f(r, g, b, a);
                    model.render(tessellator);
                }
            }
            GL11.glDepthFunc(515);
            GL11.glDisable(3042);
            GL11.glEnable(3008);
            GL11.glEnable(3553);
        }
        GL11.glPopMatrix();
        GL11.glEnable(2884);
        GL11.glDisable(3042);
        GL11.glDisable(32826);
        this.renderSpecials(tessellator, entity, x, y, z);
    }

    protected void preRenderTransform(@NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glTranslated(x, y, z);
        GL11.glRotatef(-this.getBodyYaw(entity, partialTick) * MathHelper.RAD_TO_DEG, 0.0f, 1.0f, 0.0f);
        GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
        if (((Mob)entity).deathTime > 0) {
            float rotationProgress = ((float)((Mob)entity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GL11.glRotatef(rotationProgress * this.getMaxDeathRotation(entity), 0.0f, 0.0f, 1.0f);
        }
        if (entity instanceof AgedMob) {
            AgedMob agedMob = (AgedMob)entity;
            float ageScale = agedMob.getMobAge().getAgeScale();
            GL11.glScalef(ageScale, ageScale, ageScale);
        }
    }

    @Override
    public float getShadowSize(@NotNull T entity) {
        float baseSize = super.getShadowSize(entity);
        if (entity instanceof AgedMob) {
            AgedMob agedMob = (AgedMob)entity;
            float ageScale = agedMob.getMobAge().getAgeScale();
            return baseSize * ageScale;
        }
        return baseSize;
    }

    protected float getLimbSwing(@NotNull T entity, float partialTick) {
        return ((Mob)entity).walkAnimPos - ((Mob)entity).walkAnimSpeed * (1.0f - partialTick);
    }

    protected float getLimbYaw(@NotNull T entity, float partialTick) {
        float limbYaw = MathHelper.lerp(((Mob)entity).walkAnimSpeedO, ((Mob)entity).walkAnimSpeed, partialTick);
        if (limbYaw > 1.0f) {
            limbYaw = 1.0f;
        }
        return limbYaw;
    }

    protected float getLimbPitch(@NotNull T entity, float partialTick) {
        return (float)((Mob)entity).tickCount + partialTick;
    }

    protected float getBodyYaw(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).yBodyRotO, ((Mob)entity).yBodyRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected float getHeadYaw(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).yRotO, ((Mob)entity).yRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected float getHeadPitch(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).xRotO, ((Mob)entity).xRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected void renderSpecials(@NotNull Tessellator tessellator, @NotNull T entity, double x, double y, double z) {
        if (Minecraft.getMinecraft().canRenderEntityLabel()) {
            this.renderLivingLabel(tessellator, entity, Integer.toString(((Mob)entity).id), x, y, z, 64, false);
        } else if (!((Mob)entity).nickname.isEmpty()) {
            this.renderLivingLabel(tessellator, entity, ((Mob)entity).getDisplayName(), x, y, z, 64, true);
        }
    }

    protected void renderLivingLabel(@NotNull Tessellator t, @NotNull T entity, @NotNull CharSequence text, double x, double y, double z, int maxDistance, boolean depthTest) {
        float cameraDistance = (float)this.renderDispatcher.camera.distanceTo((Entity)entity);
        if (cameraDistance > (float)maxDistance) {
            return;
        }
        FontRenderer sr = this.getFont();
        float scale = 0.026666667f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y + ((Mob)entity).getHeadHeight() + 0.8f, (float)z);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-this.renderDispatcher.viewLerpYaw, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.renderDispatcher.viewLerpPitch, 1.0f, 0.0f, 0.0f);
        GL11.glScalef(-0.026666667f, -0.026666667f, 0.026666667f);
        GL11.glDisable(2896);
        GL11.glDepthMask(false);
        if (!depthTest) {
            GL11.glDisable(2929);
        }
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDisable(3553);
        t.startDrawingQuads();
        int halfTextWidth = sr.stringWidth(text) / 2;
        t.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        t.addVertex(-halfTextWidth - 1, -1.0, 0.0);
        t.addVertex(-halfTextWidth - 1, 8.0, 0.0);
        t.addVertex(halfTextWidth, 8.0, 0.0);
        t.addVertex(halfTextWidth, -1.0, 0.0);
        t.draw();
        GL11.glEnable(3553);
        sr.render(t, text, -halfTextWidth, 0).setColor(0x20FFFFFF).call();
        if (!depthTest) {
            GL11.glEnable(2929);
        }
        GL11.glDepthMask(true);
        sr.render(t, text, -halfTextWidth, 0).setColor(0xFFFFFF).call();
        GL11.glEnable(2896);
        GL11.glDisable(3042);
        GL11.glPopMatrix();
    }

    protected int getOverlayColor(@NotNull T entity, float brightness, float partialTick) {
        return 0;
    }

    protected float getMaxDeathRotation(@NotNull T entity) {
        return 90.0f;
    }

    protected int maxRenderLayer(@NotNull T entity) {
        return 0;
    }

    @Nullable
    protected abstract StaticEntityModel getAndSetupModelForLayer(@NotNull T var1, float var2, float var3, int var4);

    protected void renderAdditional(@NotNull Tessellator tessellator, @NotNull T entity, float partialTick) {
    }

    public void loadEntityTexture(@NotNull T entity) {
        if (!((Boolean)Minecraft.getMinecraft().gameSettings.mobVariants.value).booleanValue()) {
            this.bindTexture(((Mob)entity).getDefaultEntityTexture());
        } else {
            this.bindTexture(((Mob)entity).getEntityTexture());
        }
    }

    @Override
    @NotNull
    public AABBdc entityViewBox(@NotNull T entity) {
        return super.entityViewBox(entity);
    }
}

