/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TessellatorStandard
extends TessellatorBase
implements ParticleTessellator {
    private static final Logger LOGGER = LogUtils.getLogger();
    public VertexData data;
    public boolean drawing;
    private int color;
    private int lightmapCoord;
    private double textureU;
    private double textureV;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private boolean lockedColor = false;
    private double particleYRot;
    private double particleXRot;
    private double particleXA;
    private double particleZA;
    private double particleXA2;
    private double particleZA2;
    private double particleYA;

    public TessellatorStandard(int bufferSize) {
        this.data = new VertexData(bufferSize);
    }

    @Override
    public void startDrawing(int drawMode) {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        VertexConfig config = this.data.config;
        config.drawMode = drawMode;
        this.drawing = true;
        this.data.vertexCount = 0;
        config.enableColor = false;
        config.enableTexture = false;
        config.enableLightmap = false;
        config.enableNormal = false;
        this.lockedColor = false;
        this.data.buffer.clear();
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.data.vertexCount == 0) {
            return;
        }
        this.data.buffer.flip();
        this.data.drawAll();
    }

    public int getVertexSize() {
        return this.data.config.getVertexSize();
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        if (this.data.buffer.capacity() < this.data.buffer.position() + 64) {
            int newSize = this.data.buffer.capacity() * 2;
            LOGGER.info("Expanding Tessellator Buffer ({} -> {})", (Object)this.data.buffer.capacity(), (Object)newSize);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
            this.data.buffer.flip();
            newBuffer.put(this.data.buffer);
            this.data.buffer = newBuffer;
        }
        ByteBuffer buffer = this.data.buffer;
        buffer.putFloat((float)(this.offsetX + x));
        buffer.putFloat((float)(this.offsetY + y));
        buffer.putFloat((float)(this.offsetZ + z));
        VertexConfig config = this.data.config;
        if (config.enableColor) {
            buffer.putInt(this.color);
        }
        if (config.enableTexture) {
            buffer.putFloat((float)this.textureU);
            buffer.putFloat((float)this.textureV);
        }
        if (config.enableLightmap) {
            buffer.putInt(this.lightmapCoord);
        }
        if (config.enableNormal) {
            buffer.put(this.normalX);
            buffer.put(this.normalY);
            buffer.put(this.normalZ);
        }
        ++this.data.vertexCount;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        if (!this.data.config.enableTexture) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.data.config.enableTexture = true;
        }
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void startDrawingParticles() {
        this.startDrawingQuads();
    }

    @Override
    public void setLightmapCoord(int lightmapCoord) {
        this.checkIsDrawing();
        if (!this.data.config.enableLightmap) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Lightmap is disabled!");
            }
            this.data.config.enableLightmap = true;
        }
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void setColorRGBA(int r, int g, int b, int a) {
        this.checkIsDrawing();
        if (this.lockedColor) {
            return;
        }
        if (!this.data.config.enableColor) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Color is disabled!");
            }
            this.data.config.enableColor = true;
        }
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        a = MathHelper.clamp(a, 0, 255);
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void setupParticleValues(@NotNull ICamera camera, float partialTick) {
        this.particleYRot = camera.getYRot(partialTick);
        this.particleXRot = camera.getXRot(partialTick);
        this.particleXA = MathHelper.cos((float)(this.particleYRot * Math.PI) / 180.0f);
        this.particleZA = MathHelper.sin((float)(this.particleYRot * Math.PI) / 180.0f);
        this.particleXA2 = -this.particleZA * (double)MathHelper.sin((float)(this.particleXRot * Math.PI / 180.0));
        this.particleZA2 = this.particleXA * (double)MathHelper.sin((float)(this.particleXRot * Math.PI / 180.0));
        this.particleYA = MathHelper.cos((float)(this.particleXRot * Math.PI / 180.0));
    }

    @Override
    public void addParticle(double x, double y, double z, float scale, double u, double v, double uSize, double vSize) {
        this.addVertexWithUV(x - this.particleXA * (double)scale - this.particleXA2 * (double)scale, y - this.particleYA * (double)scale, z - this.particleZA * (double)scale - this.particleZA2 * (double)scale, u + uSize, v + vSize);
        this.addVertexWithUV(x - this.particleXA * (double)scale + this.particleXA2 * (double)scale, y + this.particleYA * (double)scale, z - this.particleZA * (double)scale + this.particleZA2 * (double)scale, u + uSize, v);
        this.addVertexWithUV(x + this.particleXA * (double)scale + this.particleXA2 * (double)scale, y + this.particleYA * (double)scale, z + this.particleZA * (double)scale + this.particleZA2 * (double)scale, u, v);
        this.addVertexWithUV(x + this.particleXA * (double)scale - this.particleXA2 * (double)scale, y - this.particleYA * (double)scale, z + this.particleZA * (double)scale - this.particleZA2 * (double)scale, u, v + vSize);
    }

    @Override
    public void drawParticles() {
        this.draw();
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        if (!this.data.config.enableNormal) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.data.config.enableNormal = true;
        }
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockedColor = true;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    @Override
    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }
}

