/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.debug;

import java.lang.reflect.Field;
import java.util.Map;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.APIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLFWLoggerCallback
implements GLFWErrorCallbackI {
    private final Logger LOGGER = LoggerFactory.getLogger("GLFW");
    private final Map<Integer, String> errorCodes = APIUtil.apiClassTokens(GLFWLoggerCallback::filter, null, GLFW.class);

    @Override
    public void invoke(int error, long description) {
        String msg = GLFWErrorCallback.getDescription(description);
        StringBuilder sb = new StringBuilder(512).append("ERROR: ").append(this.errorCodes.get(error)).append("\n").append("\tDescription : ").append(msg).append("\n").append("\tStacktrace  :\n");
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 4; i < stack.length; ++i) {
            sb.append("\t\t");
            sb.append(stack[i]);
            sb.append("\n");
        }
        this.LOGGER.error("{}", (Object)sb);
    }

    public static boolean filter(Field field, Integer value) {
        return 65536 <= value && value <= 131071;
    }
}

