/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicRope
extends BlockLogic {
    public static final int MASK_ROPE_CONNECT = 128;

    public BlockLogicRope(@NotNull Block<?> block) {
        super(block, Materials.CLOTH);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean isClimbable(@NotNull World world, @NotNull TilePosc tilePos) {
        return true;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        boolean hasBlockNegX = source.getBlockId(tilePos.add(-1, 0, 0, queryPos)) == this.id();
        boolean hasBlockPosX = source.getBlockId(tilePos.add(1, 0, 0, queryPos)) == this.id();
        boolean hasBlockNegY = source.getBlockId(tilePos.add(0, -1, 0, queryPos)) == this.id();
        boolean hasBlockPosY = source.getBlockId(tilePos.add(0, 1, 0, queryPos)) == this.id() || source.isBlockOpaqueCube(tilePos.add(0, 1, 0, queryPos));
        boolean hasBlockNegZ = source.getBlockId(tilePos.add(0, 0, -1, queryPos)) == this.id();
        boolean hasBlockPosZ = source.getBlockId(tilePos.add(0, 0, 1, queryPos)) == this.id();
        float minX = 0.3125f;
        float maxX = 0.6875f;
        float minY = 0.3125f;
        float maxY = 0.6875f;
        float minZ = 0.3125f;
        float maxZ = 0.6875f;
        if (hasBlockNegX) {
            minX = 0.0f;
        }
        if (hasBlockPosX) {
            maxX = 1.0f;
        }
        if (hasBlockNegY) {
            minY = 0.0f;
        }
        if (hasBlockPosY) {
            maxY = 1.0f;
        }
        if (hasBlockNegZ) {
            minZ = 0.0f;
        }
        if (hasBlockPosZ) {
            maxZ = 1.0f;
        }
        return new AABBd(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemToolShears) {
            int meta = world.getBlockData(tilePos);
            int forceRope = ~meta & 0x80;
            world.setBlockDataNotify(tilePos, forceRope | meta & 0xFFFFFF7F);
            heldItem.damageItem(1, player);
            if (heldItem.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (heldItem == null) {
            this.pickUpRope(world, tilePos, player);
            return true;
        }
        return false;
    }

    public void pickUpRope(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player) {
        ItemStack stack;
        Block<?> block;
        if (world.isClientSide || world.getBlock(tilePos) != this.block) {
            return;
        }
        TilePos queryPos = new TilePos();
        int highestRope = tilePos.y();
        int y = tilePos.y();
        while (tilePos.y() > 0 && (block = world.getBlock(tilePos.down(queryPos))) == this.block) {
            --y;
        }
        int lowestRope = y;
        int freeSpace = 0;
        for (int i = 0; i < player.inventory.mainInventory.length; ++i) {
            stack = player.inventory.mainInventory[i];
            if (stack == null) {
                freeSpace += Items.ROPE.getItemStackLimit(null);
                continue;
            }
            if (stack.getItem() != Items.ROPE) continue;
            freeSpace += Items.ROPE.getItemStackLimit(null) - stack.stackSize;
        }
        freeSpace = Math.min(freeSpace, 1);
        int ropesCollected = 0;
        for (y = lowestRope; y <= highestRope && ropesCollected < freeSpace; ++ropesCollected, ++y) {
            world.setBlockIdNotify(tilePos, 0);
        }
        if (player.getGamemode().consumeBlocks()) {
            stack = new ItemStack(Items.ROPE, ropesCollected);
            player.inventory.insertItem(stack, true);
            if (stack.stackSize > 0) {
                player.dropPlayerItem(stack);
            }
        }
        world.playBlockSoundEffect(player, (double)tilePos.x() + 0.5, (double)highestRope + 0.5, (double)tilePos.z() + 0.5, this.block, EnumBlockSoundEffectType.PLACE);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.ROPE)};
    }
}

