/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class ItemToolSword
extends Item {
    private final int weaponDamage;
    private final ToolMaterial material;

    public ItemToolSword(@NotNull String name, @NotNull String namespaceId, int id, @NotNull ToolMaterial toolMaterial) {
        super(name, namespaceId, id);
        this.setMaxDamage(toolMaterial.getDurability());
        this.maxStackSize = 1;
        this.weaponDamage = 4 + toolMaterial.getDamage() * 2;
        this.material = toolMaterial;
    }

    @Override
    public float getStrVsBlock(@NotNull ItemStack selfStack, @NotNull Block<?> block) {
        return block != Blocks.COBWEB ? 1.5f : 15.0f;
    }

    @Override
    public boolean hitEntity(@NotNull ItemStack selfStack, @NotNull Mob target, @NotNull Mob attacker) {
        selfStack.damageItem(1, attacker);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Mob mob, @NotNull Block<?> removedBlock, @NotNull TilePos blockPos, @NotNull Side side) {
        if (removedBlock.getHardness() > 0.0f || this.isSilkTouch()) {
            selfStack.damageItem(2, mob);
        }
        return true;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        Block<?> b = world.getBlock(blockPos = blockPos.add(direction, new TilePos()));
        if (b == Blocks.PUMPKIN) {
            world.setBlockIdData(blockPos, Blocks.PUMPKIN_CARVED_IDLE.id(), direction.getOpposite().getId());
            selfStack.damageItem(1, null);
        }
    }

    @Override
    public int getDamageVsEntity(@NotNull ItemStack selfStack, @NotNull Entity entity) {
        return this.weaponDamage;
    }

    @Override
    public boolean canHarvestBlock(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Block<?> block) {
        return block.hasTag(BlockTags.MINEABLE_BY_SWORD);
    }

    @Override
    public boolean isSilkTouch() {
        return this.material.isSilkTouch();
    }
}

