/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.IntegerCoordinate;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.world.pos.TilePosc;

public class ArgumentTypeIntegerCoordinates
implements ArgumentType<IntegerCoordinates> {
    private static final List<String> EXAMPLES = Arrays.asList("~ ~ ~", "0 0 0", "~ ~60 ~", "~-20 ~10 -25");

    public static ArgumentTypeIntegerCoordinates intCoordinates() {
        return new ArgumentTypeIntegerCoordinates();
    }

    @Override
    public IntegerCoordinates parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        IntegerCoordinate x = IntegerCoordinate.parse(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            if (reader.peek() == 'f' || reader.peek() == 'd') {
                reader.skip();
                if (!reader.canRead() || reader.peek() != ' ') {
                    reader.setCursor(i);
                    throw CommandExceptions.incomplete().createWithContext(reader);
                }
            } else {
                reader.setCursor(i);
                throw CommandExceptions.incomplete().createWithContext(reader);
            }
        }
        reader.skip();
        IntegerCoordinate y = IntegerCoordinate.parse(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            if (reader.peek() == 'f' || reader.peek() == 'd') {
                reader.skip();
                if (!reader.canRead() || reader.peek() != ' ') {
                    reader.setCursor(i);
                    throw CommandExceptions.incomplete().createWithContext(reader);
                }
            } else {
                reader.setCursor(i);
                throw CommandExceptions.incomplete().createWithContext(reader);
            }
        }
        reader.skip();
        IntegerCoordinate z = IntegerCoordinate.parse(reader);
        return new IntegerCoordinates(x, y, z);
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String string = builder.getRemaining();
        TilePosc coordinates = ((CommandSource)context.getSource()).getBlockCoordinates();
        if (coordinates == null) {
            return builder.buildFuture();
        }
        int[] roundedCoordinates = new int[]{coordinates.x(), coordinates.y(), coordinates.z()};
        if (string.isEmpty()) {
            String allCoordinates = roundedCoordinates[0] + " " + roundedCoordinates[1] + " " + roundedCoordinates[2];
            try {
                this.parse(new StringReader(allCoordinates));
                builder.suggest(String.valueOf(roundedCoordinates[0]));
                builder.suggest(roundedCoordinates[0] + " " + roundedCoordinates[1]);
                builder.suggest(allCoordinates);
            }
            catch (CommandSyntaxException commandSyntaxException) {}
        } else {
            String[] strings = string.split(" ");
            switch (strings.length) {
                case 1: {
                    String allCoordinates = strings[0] + " " + roundedCoordinates[1] + " " + roundedCoordinates[2];
                    try {
                        this.parse(new StringReader(allCoordinates));
                        builder.suggest(strings[0] + " " + roundedCoordinates[1]);
                        builder.suggest(allCoordinates);
                    }
                    catch (CommandSyntaxException commandSyntaxException) {}
                    break;
                }
                case 2: {
                    String allCoordinates = strings[0] + " " + strings[1] + " " + roundedCoordinates[2];
                    try {
                        this.parse(new StringReader(allCoordinates));
                        builder.suggest(allCoordinates);
                        break;
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

