/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.MutableWorldSource;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.SeasonManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlocksContainer
implements MutableWorldSource {
    @NotNull
    public final World world;
    @NotNull
    private final @NotNull Map<@NotNull TilePos, @NotNull BlockEntry> blockEntryMap = new HashMap<TilePos, BlockEntry>();
    @Nullable
    private Entity lightRefEntity = null;

    public BlocksContainer(@NotNull World world) {
        this.world = world;
    }

    @Override
    public int getHeightBlocks() {
        return this.world.getHeightBlocks();
    }

    public void setLightReferenceEntity(@Nullable Entity entity) {
        this.lightRefEntity = entity;
    }

    @Override
    public boolean setBlockId(@NotNull TilePosc tilePos, int id) {
        this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(id, 0, null));
        return true;
    }

    @Deprecated
    public void setBlock(int x, int y, int z, int id, int data, @Nullable TileEntity tileEntity) {
        @NotNull TilePos tilePos = new TilePos(x, y, z);
        this.setBlockIdData(tilePos, id, data);
        if (tileEntity != null) {
            this.setTileEntity(tilePos, tileEntity);
        }
    }

    @Override
    public boolean setBlockData(@NotNull TilePosc tilePos, int data) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.data = data;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockId(tilePos), data, this.world.getTileEntity(tilePos)));
        }
        return true;
    }

    @Override
    public boolean setBlockIdData(@NotNull TilePosc tilePos, int id, int data) {
        this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(id, data, null));
        return true;
    }

    @Override
    public void setLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos, int value) {
    }

    @Override
    public void setTileEntity(@NotNull TilePosc tilePos, @NotNull TileEntity tileEntity) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.tileEntity = tileEntity;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockId(tilePos), this.world.getBlockData(tilePos), tileEntity));
        }
    }

    @Override
    public void removeTileEntity(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.tileEntity = null;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockId(tilePos), this.world.getBlockData(tilePos), null));
        }
    }

    @Nullable
    public BlockEntry getEntry(@NotNull TilePosc tilePos) {
        return this.blockEntryMap.get(tilePos);
    }

    @Deprecated
    @Nullable
    public BlockEntry getEntry(int x, int y, int z) {
        return this.getEntry(new TilePos(x, y, z));
    }

    @NotNull
    public @NotNull Collection<@NotNull BlockEntry> getEntries() {
        return this.blockEntryMap.values();
    }

    public void clear() {
        this.blockEntryMap.clear();
    }

    @Override
    public int getBlockId(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.id;
        }
        return this.world.getBlockId(tilePos);
    }

    @Override
    @Nullable
    public Block<?> getBlock(@NotNull TilePosc tilePos) {
        return Blocks.getBlock(this.getBlockId(tilePos));
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.tileEntity;
        }
        return this.world.getTileEntity(tilePos);
    }

    @Override
    public float getBrightness(@NotNull TilePosc tilePos, int lightEmission) {
        if (this.lightRefEntity != null) {
            return this.lightRefEntity.getBrightness(1.0f);
        }
        return this.world.getBrightness(tilePos, lightEmission);
    }

    @Override
    public int getLightmapCoord(@NotNull TilePosc tilePos, int lightEmission) {
        if (this.lightRefEntity != null) {
            return this.lightRefEntity.getLightmap(1.0f);
        }
        return this.world.getLightmapCoord(tilePos, lightEmission);
    }

    @Override
    public int getLightmapCoord(int skyLight, int blockLight) {
        return this.world.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public float getLightBrightness(@NotNull TilePosc tilePos) {
        return this.world.getLightBrightness(tilePos);
    }

    @Override
    public int getBlockData(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.data;
        }
        return this.world.getBlockData(tilePos);
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block == null) {
            return Materials.AIR;
        }
        return block.getMaterial();
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos);
    }

    @Override
    public double getBlockTemperature(@NotNull TilePosc tilePos) {
        return this.world.getBlockTemperature(tilePos);
    }

    @Override
    public double getBlockHumidity(@NotNull TilePosc tilePos) {
        return this.world.getBlockHumidity(tilePos);
    }

    @Override
    public double getBlockVariety(@NotNull TilePosc tilePos) {
        return this.world.getBlockVariety(tilePos);
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.world.getSeasonManager();
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc tilePos) {
        return this.world.getBlockBiome(tilePos);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos) {
        return this.world.getSavedLightValue(lightLayer, tilePos);
    }

    @Override
    public boolean isRetro() {
        return this.world.isRetro();
    }

    public static class BlockEntry {
        public int id;
        public int data;
        @Nullable
        public TileEntity tileEntity;

        public BlockEntry(int id, int data, @Nullable TileEntity tileEntity) {
            this.id = id;
            this.data = data;
            this.tileEntity = tileEntity;
        }
    }
}

