/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.error;

import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tessellator.TessellatorStandard;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class ScreenMissingMinecraft
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    public int ticks = 0;

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.buttons.clear();
        String downloadString = i.translateKey("gui.no_minecraft.button.guide");
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120 + 12, i.translateKey("gui.no_minecraft.button.quit")));
        ClickableLabelElement installLabel = new ClickableLabelElement(1, this.width / 2 - 170, this.height / 4 - 60 + 60 + 64, downloadString, 8165866);
        this.buttons.add(installLabel);
        this.buttons.add(new ClickableLabelElement(2, 0, this.height - this.mc.font.getFont().fontHeight() - 4, i.translateKey("gui.main_menu.button.discord"), 5793266));
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i = I18n.getInstance();
        this.drawBackground(partialTick);
        this.drawStringCenteredShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFF60);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.1"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 0, 0xDEDEDE);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 18, 0xDEDEDE);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.3"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 27, 0xDEDEDE);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.4"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 45, 0xDEDEDE);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_minecraft.label.body.5"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 54, 0xDEDEDE);
        super.render(mx, my, partialTick);
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.shutdown();
        }
        if (button.id == 1) {
            UrlHelper.openURL("https://www.betterthanadventure.net/installation-guide/");
        } else if (button.id == 2) {
            UrlHelper.openURL("https://betterthanadventure.net/discord");
        }
    }

    @Override
    public void tick() {
        this.ticks += 30;
    }

    public void drawBackground(float partialTick) {
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        TessellatorStandard tessellator = Tessellator.instance;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/block/cobbled_netherrack_mossy.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(3042);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/block/dirt.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(0.2509804f, 0.2509804f, 0.2509804f, MathHelper.clamp(1.0f - ((float)this.ticks + partialTick) / 80000.0f, 0.0f, 1.0f));
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        this.drawGradientRect(0, 0, this.width, this.height, 0x22402020, -11530224);
    }
}

