/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelCropsWheat<T extends BlockLogic>
extends BlockModelStandard<T> {
    public final IconCoordinate[] growthStageTextures = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/crops_wheat/stage0"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage1"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage2"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage3"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage4"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage5"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage6"), TextureRegistry.getTexture("minecraft:block/crops_wheat/stage7")};

    public BlockModelCropsWheat(Block<T> block) {
        super(block);
        assert (this.growthStageTextures.length == 8) : "There must be a texture for each wheat growth stage!";
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, tilePos));
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, tilePos);
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, worldSource.getBlockData(tilePos));
        if (BlockModelCropsWheat.renderBlocks.overrideBlockTexture != null) {
            texture = BlockModelCropsWheat.renderBlocks.overrideBlockTexture;
        }
        double uMin = texture.getIconUMin();
        double uMax = texture.getIconUMax();
        double vMin = texture.getIconVMin();
        double vMax = texture.getIconVMax();
        double xMin = (double)tilePos.x() + 0.5 - 0.25;
        double xMax = (double)tilePos.x() + 0.5 + 0.25;
        double zMin = (double)tilePos.z() + 0.5 - 0.5;
        double zMax = (double)tilePos.z() + 0.5 + 0.5;
        double yd = (float)tilePos.y() - 0.0625f;
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMax, vMin);
        xMin = (double)tilePos.x() + 0.5 - 0.5;
        xMax = (double)tilePos.x() + 0.5 + 0.5;
        zMin = (double)tilePos.z() + 0.5 - 0.25;
        zMax = (double)tilePos.z() + 0.5 + 0.25;
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMax, vMin);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        return this.growthStageTextures[MathHelper.clamp(data, 0, 7)];
    }
}

