/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleFlame
extends Particle {
    private final float oSize;

    public ParticleFlame(World world, double x, double y, double z, double xd, double yd, double zd, Type type) {
        super(world, x, y, z, xd, yd, zd);
        this.xd = this.xd * 0.01 + xd;
        this.yd = this.yd * 0.01 + yd;
        this.zd = this.zd * 0.01 + zd;
        this.x += (double)((random.nextFloat() - random.nextFloat()) * 0.05f);
        this.y += (double)((random.nextFloat() - random.nextFloat()) * 0.05f);
        this.z += (double)((random.nextFloat() - random.nextFloat()) * 0.05f);
        this.oSize = this.size;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.noPhysics = true;
        this.tex = type.texture;
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        float s = ((float)this.age + partialTick) / (float)this.lifetime;
        this.size = this.oSize * (1.0f - s * s * 0.5f);
        super.render(t, partialTick);
    }

    @Override
    public float calcBrightness(float partialTick) {
        float decay = MathHelper.clamp(((float)this.age + partialTick) / (float)this.lifetime, 0.0f, 1.0f);
        return super.calcBrightness(partialTick) * decay + (1.0f - decay);
    }

    @Override
    public int calcLightmap(float partialTick) {
        return LightmapHelper.setBlocklightValue(super.calcLightmap(partialTick), 15);
    }

    @Override
    public void tick() {
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public static enum Type {
        ORANGE(TextureRegistry.getTexture("minecraft:particle/fire")),
        SOUL(TextureRegistry.getTexture("minecraft:particle/fire_soul")),
        BLUE(TextureRegistry.getTexture("minecraft:particle/fire_blue"));

        private final IconCoordinate texture;

        private Type(IconCoordinate tex) {
            this.texture = tex;
        }
    }
}

