/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class Shaders {
    private static int fullscreenRectList;
    public static boolean enableShaders;
    private static final long startTime;
    private static float frameTimeCounter;

    public static void drawFullscreenRect() {
        GL11.glDisable(3042);
        GL11.glDisable(2912);
        GL11.glDisable(2929);
        GL11.glDisable(2884);
        GL11.glDisable(2896);
        GL11.glDisable(3089);
        GL11.glDisable(3008);
        GL11.glColor4d(1.0, 1.0, 1.0, 1.0);
        GL11.glEnable(3553);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5889);
        if (fullscreenRectList == 0) {
            fullscreenRectList = GL11.glGenLists(1);
            GL11.glNewList(fullscreenRectList, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2d(0.0, 0.0);
            GL11.glVertex2d(-1.0, -1.0);
            GL11.glTexCoord2d(0.0, 1.0);
            GL11.glVertex2d(-1.0, 1.0);
            GL11.glTexCoord2d(1.0, 1.0);
            GL11.glVertex2d(1.0, 1.0);
            GL11.glTexCoord2d(1.0, 0.0);
            GL11.glVertex2d(1.0, -1.0);
            GL11.glEnd();
            GL11.glEndList();
        }
        GL11.glCallList(fullscreenRectList);
    }

    public static void setUniforms(Minecraft minecraft, Shader shader, float partialTicks) {
        long now = System.currentTimeMillis();
        int passedTime = (int)(now - startTime);
        frameTimeCounter = (float)passedTime / 1000.0f;
        if (!shader.isEnabled()) {
            return;
        }
        shader.bind();
        shader.uniformFloat("width", minecraft.gameWindow.getWidthPixels());
        shader.uniformFloat("height", minecraft.gameWindow.getHeightPixels());
        shader.uniformFloat("frameTimeCounter", frameTimeCounter);
        shader.uniformFloat("gamma", ((Float)minecraft.gameSettings.gamma.value).floatValue());
        shader.uniformFloat("fxaa", ((Float)minecraft.gameSettings.fxaa.value).floatValue());
        shader.uniformFloat("heatHaze", (Boolean)minecraft.gameSettings.heatHaze.value != false ? minecraft.ppm.lerped.heatHaze : 0.0f);
        shader.uniformInt("bloom", (Integer)minecraft.gameSettings.bloom.value);
        shader.uniformInt("dimension", minecraft.currentWorld != null && minecraft.currentWorld.dimension != null ? minecraft.currentWorld.dimension.id : 0);
        shader.uniformInt("cbCorrectionMode", ((Colorblindness)((Object)minecraft.gameSettings.colorblindnessFix.value)).ordinal());
        ItemStack helmet = minecraft.thePlayer == null ? null : minecraft.thePlayer.getItemInArmorSlot(HumanArmorShape.HEAD);
        shader.uniformInt("shaderEffect", helmet != null && helmet.itemID == Blocks.PUMPKIN_REDSTONE.id() ? 1 : 0);
        int isEyeInLiquid = 0;
        float celestialAngle = 0.0f;
        if (minecraft.thePlayer != null && minecraft.currentWorld != null && minecraft.activeCamera != null) {
            if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.currentWorld, Materials.LAVA, partialTicks)) {
                isEyeInLiquid = 2;
            } else if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.currentWorld, Materials.WATER, partialTicks)) {
                isEyeInLiquid = 1;
            }
            celestialAngle = minecraft.currentWorld.getCelestialAngle(partialTicks);
        }
        shader.uniformInt("isEyeInLiquid", isEyeInLiquid);
        shader.uniformFloat("celestialAngle", celestialAngle);
        if (minecraft.ppm.enabled) {
            shader.uniformFloat("brightness", minecraft.ppm.lerped.brightness);
            shader.uniformFloat("contrast", minecraft.ppm.lerped.contrast);
            shader.uniformFloat("exposure", minecraft.ppm.lerped.exposure);
            shader.uniformFloat("saturation", minecraft.ppm.lerped.saturation);
            shader.uniformFloat("rMod", minecraft.ppm.lerped.rMod);
            shader.uniformFloat("gMod", minecraft.ppm.lerped.gMod);
            shader.uniformFloat("bMod", minecraft.ppm.lerped.bMod);
        } else {
            shader.uniformFloat("brightness", 0.0f);
            shader.uniformFloat("contrast", 0.0f);
            shader.uniformFloat("exposure", 0.0f);
            shader.uniformFloat("saturation", 0.0f);
            shader.uniformFloat("rMod", 1.0f);
            shader.uniformFloat("gMod", 1.0f);
            shader.uniformFloat("bMod", 1.0f);
        }
        shader.uniformFloat("photoMode", minecraft.currentScreen instanceof ScreenPhotoMode);
        shader.uniformFloat("guiOpened", minecraft.currentScreen != null);
        if (minecraft.currentScreen instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)minecraft.currentScreen;
            shader.uniformFloat("intensity", screenPhotoMode.intensityValue);
        } else {
            shader.uniformFloat("intensity", 1.0f);
        }
    }

    static {
        enableShaders = false;
        startTime = System.currentTimeMillis();
        frameTimeCounter = 0.0f;
    }
}

