/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererStatue
extends TileEntityRenderer<TileEntityStatue> {
    @NotNull
    public static final @NotNull Map<@NotNull Block<?>, @NotNull String> BLOCK_SKIN_MAP = new HashMap();

    @NotNull
    private StaticEntityModel model(boolean isPigman) {
        if (isPigman) {
            return this.getModel("main.pigman");
        }
        return this.getModel("main");
    }

    public void renderAt(@NotNull Tessellator tessellator, @Nullable ItemStack heldStack, int meta, @NotNull Block<?> lowerBlock, @NotNull TileEntityStatue.Pose pose, @Nullable IArmorWearing<HumanArmorShape> armorWearer, double x, double y, double z) {
        boolean isPigman = lowerBlock == Blocks.STATUE_PIGMAN_LOWER;
        StaticEntityModel model = this.model(isPigman);
        GL12.glEnable(32826);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.bindTexture(BLOCK_SKIN_MAP.getOrDefault(lowerBlock, BLOCK_SKIN_MAP.get(Blocks.STATUE_STONE_LOWER)));
        GL11.glPushMatrix();
        GL11.glTranslated(x + 0.5, y, z + 0.5);
        float rotation = (float)(meta * 360) / 16.0f;
        GL11.glRotatef(-rotation, 0.0f, 1.0f, 0.0f);
        GL11.glDisable(2884);
        GL11.glPushMatrix();
        GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
        model.resetBones();
        this.renderModel(tessellator, model, pose);
        if (armorWearer != null) {
            for (int i = 0; i < 4; ++i) {
                this.renderArmor(tessellator, armorWearer, i, pose);
            }
        }
        this.renderHeldItem(heldStack, isPigman);
        GL11.glPopMatrix();
        GL11.glEnable(2884);
        GL11.glPopMatrix();
        GL12.glDisable(32826);
    }

    private void renderHeldItem(@Nullable ItemStack itemStack, boolean isPigman) {
        if (itemStack != null) {
            GL12.glEnable(32826);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.model(isPigman).translateToBone("rightItem");
            GL11.glScalef(-1.0f, 1.0f, 1.0f);
            GL11.glScalef(16.0f, 16.0f, 16.0f);
            ItemModelDispatcher.getInstance().getDispatch(itemStack).render(Tessellator.instance, null, itemStack, "thirdperson_righthand", true, 1, 1.0f, 1.0f, 1.0f, false);
            GL11.glEnable(2884);
            GL12.glDisable(32826);
        }
    }

    private void renderModel(@NotNull Tessellator tessellator, @NotNull StaticEntityModel model, @NotNull TileEntityStatue.Pose pose) {
        model.getTransform((String)"leftArm").rotX = pose.leftArmPitch;
        model.getTransform((String)"rightArm").rotX = pose.rightArmPitch;
        model.getTransform((String)"leftLeg").rotX = pose.leftLegPitch;
        model.getTransform((String)"rightLeg").rotX = pose.rightLegPitch;
        model.getTransform((String)"head").rotX = pose.headPitch;
        model.getTransform((String)"head").rotY = pose.headYaw;
        model.render(tessellator);
    }

    @Override
    public void doRender(@NotNull Tessellator tessellator, @NotNull TileEntityStatue tileEntity, double x, double y, double z, float partialTick) {
        this.renderAt(tessellator, tileEntity.getHeldItem(), tileEntity.getBlockMeta(), tileEntity.getBlock(), tileEntity.getPose(), tileEntity, x, y, z);
        this.renderShadow(Minecraft.getMinecraft().currentWorld, tessellator, tileEntity.x, tileEntity.y, tileEntity.z, x, y, z, 2.0f, partialTick);
    }

    private boolean renderArmor(@NotNull Tessellator tessellator, @NotNull IArmorWearing<? super HumanArmorShape> armorWearer, int layer, @NotNull TileEntityStatue.Pose pose) {
        ItemStack itemstack = armorWearer.getItemInArmorSlot(HumanArmorShape.values()[armorWearer.getNumArmorSlots() - 1 - layer]);
        if (itemstack != null) {
            StaticEntityModel model;
            Item item = itemstack.getItem();
            if (item instanceof ItemQuiver) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver.png");
            } else if (item instanceof ItemQuiverEndless) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver_golden.png");
            } else if (item == Items.ARMOR_BOOTS_ICESKATES) {
                this.bindTexture("/assets/minecraft/textures/armor/skates.png");
            } else if (item instanceof IArmorItem) {
                IArmorItem armorItem = (IArmorItem)((Object)item);
                if (armorItem.getArmorMaterial() == null) {
                    return false;
                }
                this.bindTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace(), armorItem.getArmorMaterial().identifier.value(), layer != 2 ? 1 : 2));
            } else {
                return false;
            }
            switch (layer) {
                case 3: {
                    model = this.getModel("armor.boots");
                    model.resetBones();
                    model.getTransform((String)"chest").visible = false;
                    model.getTransform((String)"head").visible = false;
                    model.getTransform((String)"rightArm").visible = false;
                    model.getTransform((String)"leftArm").visible = false;
                    break;
                }
                case 2: {
                    model = this.getModel("armor.leggings");
                    model.resetBones();
                    model.getTransform((String)"head").visible = false;
                    model.getTransform((String)"rightArm").visible = false;
                    model.getTransform((String)"leftArm").visible = false;
                    break;
                }
                case 1: {
                    model = this.getModel("armor.chestplate");
                    model.resetBones();
                    model.getTransform((String)"head").visible = false;
                    model.getTransform((String)"rightLeg").visible = false;
                    model.getTransform((String)"leftLeg").visible = false;
                    break;
                }
                case 0: {
                    model = this.getModel("armor.helmet");
                    model.resetBones();
                    model.getTransform((String)"chest").visible = false;
                    model.getTransform((String)"rightArm").visible = false;
                    model.getTransform((String)"leftArm").visible = false;
                    model.getTransform((String)"rightLeg").visible = false;
                    model.getTransform((String)"leftLeg").visible = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.renderModel(tessellator, model, pose);
            return true;
        }
        return false;
    }

    private void renderShadow(@NotNull World world, @NotNull Tessellator tessellator, int bx, int by, int bz, double rx, double ry, double rz, float opacity, float partialTick) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        TextureManager textureManager = this.renderDispatcher.textureManager;
        textureManager.bindTexture(textureManager.loadTexture("/assets/minecraft/textures/misc/shadow.png"));
        float shadowSize = 0.5f;
        float shadowOffs = 0.4f;
        GL11.glDepthMask(false);
        tessellator.startDrawingQuads();
        int blockId = world.getBlockId(bx, by - 1, bz);
        if (blockId > 0 && world.getBlockLightValue(bx, by, bz) > 3) {
            this.renderShadowOnBlock(world, tessellator, Blocks.blocksList[blockId], bx, by, bz, rx, ry + (double)0.4f, rz, opacity, 0.5f);
        }
        tessellator.draw();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        GL11.glDepthMask(true);
    }

    private void renderShadowOnBlock(@NotNull World world, @NotNull Tessellator tessellator, @NotNull Block<?> block, int bx, int by, int bz, double rx, double ry, double rz, float opacity, float size) {
        double alpha;
        if (!block.isCubeShaped()) {
            return;
        }
        double brightness = world.getLightBrightness(bx, by, bz);
        if (Global.accessor.isFullbrightEnabled()) {
            brightness = 1.0;
        }
        if ((alpha = (double)opacity / 2.0 * 0.5 * brightness) < 0.0) {
            return;
        }
        if (alpha > 1.0) {
            alpha = 1.0;
        }
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)alpha);
        AABBdc aabb = block.getCollisionBoundingBoxFromPool(world, bx, by - 1, bz);
        if (aabb == null) {
            return;
        }
        double xMin = rx - 0.5;
        double xMax = rx + (aabb.maxX() - aabb.minX()) - 0.5;
        double yMin = ry + (aabb.maxY() - aabb.minY()) - 1.39;
        double zMin = rz - 0.5;
        double zMax = rz + (aabb.maxZ() - aabb.minZ()) - 0.5;
        float f2 = (float)((rx - xMin) / 2.0 / (double)size + 0.5);
        float f3 = (float)((rx - xMax) / 2.0 / (double)size + 0.5);
        float f4 = (float)((rz - zMin) / 2.0 / (double)size + 0.5);
        float f5 = (float)((rz - zMax) / 2.0 / (double)size + 0.5);
        tessellator.addVertexWithUV(xMin + 0.5, yMin, zMin + 0.5, f2, f4);
        tessellator.addVertexWithUV(xMin + 0.5, yMin, zMax + 0.5, f2, f5);
        tessellator.addVertexWithUV(xMax + 0.5, yMin, zMax + 0.5, f3, f5);
        tessellator.addVertexWithUV(xMax + 0.5, yMin, zMin + 0.5, f3, f4);
    }

    static {
        @NotNull String basePath = "/assets/minecraft/textures/entity/statue/";
        BLOCK_SKIN_MAP.put(Blocks.STATUE_STONE_LOWER, "/assets/minecraft/textures/entity/statue/stone.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_BASALT_LOWER, "/assets/minecraft/textures/entity/statue/basalt.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_LIMESTONE_LOWER, "/assets/minecraft/textures/entity/statue/limestone.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_GRANITE_LOWER, "/assets/minecraft/textures/entity/statue/granite.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_MARBLE_LOWER, "/assets/minecraft/textures/entity/statue/marble.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_PIGMAN_LOWER, "/assets/minecraft/textures/entity/statue/pigman.png");
    }
}

