#version 120

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float width;
uniform float height;
uniform float intensity;

varying vec2 texcoord;

float getDepth(vec2 coord){
	return texture2D(depthtex0, coord).r;
}

void main(){
	vec3 color = texture2D(colortex0, texcoord).rgb;
	
	float outline = 0.0;
	
	float size = 4.0 * intensity;
	
	outline += clamp(getDepth(texcoord) - getDepth(texcoord + vec2(size / width, 0)), 0.0, 1.0);
	outline += clamp(getDepth(texcoord) - getDepth(texcoord - vec2(size / width, 0)), 0.0, 1.0);
	outline += clamp(getDepth(texcoord) - getDepth(texcoord + vec2(0, size / height)), 0.0, 1.0);
	outline += clamp(getDepth(texcoord) - getDepth(texcoord - vec2(0, size / height)), 0.0, 1.0);
	
	outline = 1.0 - clamp(outline * 512, 0.0, 1.0);
	
	color *= outline;
	
	gl_FragColor = vec4(color, 1.0);
}