/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.client.gui.ScreenConnectFailed;
import net.minecraft.client.gui.ScreenDownloadTerrain;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.chat.GuiElementChatSuggestions;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.player.controller.PlayerControllerMP;
import net.minecraft.client.render.particle.ParticlePickupAnimation;
import net.minecraft.client.world.WorldClientMP;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketAESSendKey;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.net.packet.PacketAddItemEntity;
import net.minecraft.core.net.packet.PacketAddMob;
import net.minecraft.core.net.packet.PacketAddPainting;
import net.minecraft.core.net.packet.PacketAddParticle;
import net.minecraft.core.net.packet.PacketAddPlayer;
import net.minecraft.core.net.packet.PacketAnimate;
import net.minecraft.core.net.packet.PacketBedMessage;
import net.minecraft.core.net.packet.PacketBlockEvent;
import net.minecraft.core.net.packet.PacketBlockRegionUpdate;
import net.minecraft.core.net.packet.PacketBlockUpdate;
import net.minecraft.core.net.packet.PacketBoatControl;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketChunkBlocksUpdate;
import net.minecraft.core.net.packet.PacketChunkVisibility;
import net.minecraft.core.net.packet.PacketCommandManager;
import net.minecraft.core.net.packet.PacketContainerAck;
import net.minecraft.core.net.packet.PacketContainerClose;
import net.minecraft.core.net.packet.PacketContainerOpen;
import net.minecraft.core.net.packet.PacketContainerSetContent;
import net.minecraft.core.net.packet.PacketContainerSetData;
import net.minecraft.core.net.packet.PacketContainerSetSlot;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketEntityEvent;
import net.minecraft.core.net.packet.PacketEntityFling;
import net.minecraft.core.net.packet.PacketEntityNickname;
import net.minecraft.core.net.packet.PacketEntityTagData;
import net.minecraft.core.net.packet.PacketExplosion;
import net.minecraft.core.net.packet.PacketFlagOpen;
import net.minecraft.core.net.packet.PacketGameRule;
import net.minecraft.core.net.packet.PacketHandshake;
import net.minecraft.core.net.packet.PacketLogin;
import net.minecraft.core.net.packet.PacketMapData;
import net.minecraft.core.net.packet.PacketMoveEntity;
import net.minecraft.core.net.packet.PacketMovePlayer;
import net.minecraft.core.net.packet.PacketPhotoMode;
import net.minecraft.core.net.packet.PacketPlaySound;
import net.minecraft.core.net.packet.PacketPlaySoundDirect;
import net.minecraft.core.net.packet.PacketPlayerConfig;
import net.minecraft.core.net.packet.PacketPlayerGamemode;
import net.minecraft.core.net.packet.PacketPlayerList;
import net.minecraft.core.net.packet.PacketRecipeSync;
import net.minecraft.core.net.packet.PacketRemoveEntity;
import net.minecraft.core.net.packet.PacketRespawn;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetEntityData;
import net.minecraft.core.net.packet.PacketSetEntityMotion;
import net.minecraft.core.net.packet.PacketSetEquippedItem;
import net.minecraft.core.net.packet.PacketSetHealth;
import net.minecraft.core.net.packet.PacketSetHeldObject;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.net.packet.PacketSetSpawnPosition;
import net.minecraft.core.net.packet.PacketSetTime;
import net.minecraft.core.net.packet.PacketSleep;
import net.minecraft.core.net.packet.PacketStatistic;
import net.minecraft.core.net.packet.PacketSyncIDs;
import net.minecraft.core.net.packet.PacketTakeItemEntity;
import net.minecraft.core.net.packet.PacketTeleportEntity;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.net.packet.PacketUpdatePlayerProfile;
import net.minecraft.core.net.packet.PacketWeatherEffect;
import net.minecraft.core.net.packet.PacketWeatherStatus;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.ContainerSimple;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PacketHandlerClient
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean disconnected = false;
    private final NetworkManager netManager;
    public String message;
    private final Minecraft mc;
    private WorldClientMP worldClientMP;
    private boolean started = false;
    public SavedDataStorage savedDataStorage;
    public List<PlayerProfile> players;
    public HashMap<String, String> playerList = new HashMap();
    Random rand;

    public PacketHandlerClient(Minecraft minecraft, String host, int port) throws UnknownHostException, IOException {
        this.savedDataStorage = new SavedDataStorage(null);
        this.rand = new Random();
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(host), port);
        this.netManager = new NetworkManager(socket, "Client", this, -1);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void tick() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get((int)i).playerName.equals(playerProfile.playerName)) continue;
            return i;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(@NotNull PacketLogin packetLogin) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statsCounter.add(StatList.joinMultiplayerStat, 1);
        this.worldClientMP = new WorldClientMP(this, packetLogin.worldSeed, packetLogin.dimensionId, packetLogin.worldTypeId);
        this.worldClientMP.isClientSide = true;
        this.mc.changeWorld(this.worldClientMP);
        this.mc.thePlayer.dimension = packetLogin.dimensionId;
        this.mc.displayScreen(new ScreenDownloadTerrain(this));
        this.mc.thePlayer.id = packetLogin.playerEntityIdAndProtocolVersion;
        NetworkManager.PACKET_DELAY = packetLogin.packetDelay;
        Registries.RECIPES = new RecipeRegistry();
        this.addToSendQueue(new PacketPlayerConfig(this.mc.thePlayer.playerConfig));
    }

    @Override
    public void handlePlayerConfig(@NotNull PacketPlayerConfig packetPlayerConfig) {
        Entity e;
        if (packetPlayerConfig.entityId >= 0 && packetPlayerConfig.entityId != this.mc.thePlayer.id && (e = this.getEntityByID(packetPlayerConfig.entityId)) instanceof Player) {
            ((Player)e).playerConfig.config = packetPlayerConfig.config;
        }
    }

    @Override
    public void handleAddItemEntity(@NotNull PacketAddItemEntity packetAddItemEntity) {
        double x = (double)packetAddItemEntity.xPosition / 32.0;
        double y = (double)packetAddItemEntity.yPosition / 32.0;
        double z = (double)packetAddItemEntity.zPosition / 32.0;
        EntityItem entityItem = new EntityItem(this.worldClientMP, x, y, z, new ItemStack(packetAddItemEntity.itemID, packetAddItemEntity.count, packetAddItemEntity.itemDamage, packetAddItemEntity.tag));
        entityItem.xd = (double)packetAddItemEntity.xd / 128.0;
        entityItem.yd = (double)packetAddItemEntity.yd / 128.0;
        entityItem.zd = (double)packetAddItemEntity.zd / 128.0;
        entityItem.serverPosX = packetAddItemEntity.xPosition;
        entityItem.serverPosY = packetAddItemEntity.yPosition;
        entityItem.serverPosZ = packetAddItemEntity.zPosition;
        this.worldClientMP.addEntityToWorld(packetAddItemEntity.entityId, entityItem);
    }

    @Override
    public void handleAddEntity(@NotNull PacketAddEntity packetAddEntity) {
        if (!NetEntityHandler.hasType(packetAddEntity.type)) {
            return;
        }
        double xPosition = (double)packetAddEntity.xPosition / 32.0;
        double yPosition = (double)packetAddEntity.yPosition / 32.0;
        double zPosition = (double)packetAddEntity.zPosition / 32.0;
        Entity owner = packetAddEntity.ownerId >= 0 ? this.getEntityByID(packetAddEntity.ownerId) : null;
        Entity newEntity = NetEntityHandler.getTypeEntry(packetAddEntity.type).getEntity(this.worldClientMP, xPosition, yPosition, zPosition, packetAddEntity.metaData, packetAddEntity.hasVelocity, (double)packetAddEntity.xVelocity / 8000.0, (double)packetAddEntity.yVelocity / 8000.0, (double)packetAddEntity.zVelocity / 8000.0, owner, packetAddEntity.tag);
        if (newEntity != null) {
            List<SynchedEntityData.DataItem<?>> list;
            newEntity.serverPosX = packetAddEntity.xPosition;
            newEntity.serverPosY = packetAddEntity.yPosition;
            newEntity.serverPosZ = packetAddEntity.zPosition;
            newEntity.yRot = packetAddEntity.yaw;
            newEntity.xRot = packetAddEntity.pitch;
            newEntity.id = packetAddEntity.entityId;
            this.worldClientMP.addEntityToWorld(packetAddEntity.entityId, newEntity);
            if (owner instanceof Mob && newEntity instanceof Projectile) {
                ((Projectile)newEntity).owner = (Mob)owner;
            }
            if (packetAddEntity.hasVelocity) {
                newEntity.lerpMotion((double)packetAddEntity.xVelocity / 8000.0, (double)packetAddEntity.yVelocity / 8000.0, (double)packetAddEntity.zVelocity / 8000.0);
            }
            if ((list = packetAddEntity.getUnpackedData()) != null) {
                newEntity.getEntityData().assignValues(list);
            }
        }
    }

    @Override
    public void handleWeatherEffect(@NotNull PacketWeatherEffect packetWeatherEffect) {
        double x = (double)packetWeatherEffect.x / 32.0;
        double y = (double)packetWeatherEffect.y / 32.0;
        double z = (double)packetWeatherEffect.z / 32.0;
        EntityLightning weatherEntity = null;
        if (packetWeatherEffect.effectId == 1) {
            weatherEntity = new EntityLightning(this.worldClientMP, x, y, z);
        }
        if (weatherEntity != null) {
            weatherEntity.serverPosX = packetWeatherEffect.x;
            weatherEntity.serverPosY = packetWeatherEffect.y;
            weatherEntity.serverPosZ = packetWeatherEffect.z;
            weatherEntity.yRot = 0.0f;
            weatherEntity.xRot = 0.0f;
            weatherEntity.id = packetWeatherEffect.id;
            this.worldClientMP.addWeatherEffect(weatherEntity);
        }
    }

    @Override
    public void handleWeatherStatus(@NotNull PacketWeatherStatus packet) {
        if (this.worldClientMP.dimension.id != packet.dimId) {
            return;
        }
        Weather currentWeather = packet.id == -1 ? null : Weathers.WEATHERS[packet.id];
        Weather newWeather = packet.newId == -1 ? null : Weathers.WEATHERS[packet.newId];
        this.worldClientMP.weatherManager.overrideWeather(currentWeather, newWeather, packet.duration, packet.intensity, packet.power);
    }

    @Override
    public void handleAddPainting(@NotNull PacketAddPainting packetAddPainting) {
        Entity entity = this.worldClientMP.getEntityFromId(packetAddPainting.entityId);
        if (entity instanceof EntityPainting) {
            EntityPainting painting = (EntityPainting)entity;
            painting.blockX = packetAddPainting.xPosition;
            painting.blockY = packetAddPainting.yPosition;
            painting.blockZ = packetAddPainting.zPosition;
            if (ArtType.map.containsKey(packetAddPainting.key)) {
                painting.art = ArtType.map.get(packetAddPainting.key);
            }
            painting.setDirection(packetAddPainting.direction);
            if (packetAddPainting.itemID > 0) {
                painting.setStack(new ItemStack(packetAddPainting.itemID, 1, packetAddPainting.meta));
            }
        } else {
            EntityPainting entitypainting = new EntityPainting(this.worldClientMP, packetAddPainting.xPosition, packetAddPainting.yPosition, packetAddPainting.zPosition, packetAddPainting.direction, packetAddPainting.key);
            this.worldClientMP.addEntityToWorld(packetAddPainting.entityId, entitypainting);
            if (packetAddPainting.itemID > 0) {
                entitypainting.setStack(new ItemStack(packetAddPainting.itemID, 1, packetAddPainting.meta));
            }
        }
    }

    @Override
    public void handleSetEntityMotion(@NotNull PacketSetEntityMotion packetSetEntityMotion) {
        Entity entity = this.getEntityByID(packetSetEntityMotion.entityId);
        if (entity != null) {
            entity.lerpMotion((double)packetSetEntityMotion.motionX / 8000.0, (double)packetSetEntityMotion.motionY / 8000.0, (double)packetSetEntityMotion.motionZ / 8000.0);
        }
    }

    @Override
    public void handleEntityFling(@NotNull PacketEntityFling packetEntityFling) {
        Entity entity = this.getEntityByID(packetEntityFling.entityId);
        if (entity != null) {
            entity.pushesThisTick = packetEntityFling.pushesTick;
            entity.fallDistance = 0.0f;
            entity.xd = packetEntityFling.xd;
            entity.yd = packetEntityFling.yd;
            entity.zd = packetEntityFling.zd;
            entity.pushTime = packetEntityFling.pushTime;
        }
    }

    @Override
    public void handleSetEntityData(@NotNull PacketSetEntityData packetSetEntityData) {
        Entity entity = this.getEntityByID(packetSetEntityData.entityId);
        if (entity != null && packetSetEntityData.getUnpackedData() != null) {
            entity.getEntityData().assignValues(packetSetEntityData.getUnpackedData());
        }
    }

    @Override
    public void handleAddPlayer(@NotNull PacketAddPlayer packetAddPlayer) {
        double x = (double)packetAddPlayer.xPosition / 32.0;
        double y = (double)packetAddPlayer.yPosition / 32.0;
        double z = (double)packetAddPlayer.zPosition / 32.0;
        float yRot = (float)(packetAddPlayer.rotation * 360) / 256.0f;
        float xRot = (float)(packetAddPlayer.pitch * 360) / 256.0f;
        PlayerRemote playerRemote = new PlayerRemote(this.mc.currentWorld, packetAddPlayer.name, packetAddPlayer.uuid);
        UUIDHelper.nameToUUIDMap.put(packetAddPlayer.name, packetAddPlayer.uuid);
        playerRemote.playerConfig.config = packetAddPlayer.playerConfig;
        playerRemote.serverPosX = packetAddPlayer.xPosition;
        playerRemote.xo = playerRemote.serverPosX;
        playerRemote.serverPosY = packetAddPlayer.yPosition;
        playerRemote.yo = playerRemote.serverPosY;
        playerRemote.serverPosZ = packetAddPlayer.zPosition;
        playerRemote.zo = playerRemote.serverPosZ;
        int itemId = packetAddPlayer.currentItem;
        playerRemote.inventory.mainInventory[playerRemote.inventory.getCurrentItemIndex()] = itemId == 0 ? null : new ItemStack(itemId, 1, 0);
        playerRemote.absMoveTo(x, y, z, yRot, xRot);
        this.worldClientMP.addEntityToWorld(packetAddPlayer.entityId, playerRemote);
        playerRemote.nickname = StringUtils.substring(packetAddPlayer.nickname, 0, 32);
        playerRemote.chatColor = packetAddPlayer.chatColor;
        if (packetAddPlayer.gamemode >= 0 && packetAddPlayer.gamemode < Gamemode.gamemodesList.length) {
            playerRemote.setGamemode(Gamemode.gamemodesList[packetAddPlayer.gamemode]);
        }
        playerRemote.setHeldObject(packetAddPlayer.heldObjectTag == null ? null : ICarriable.createAndLoadCarriable(playerRemote, packetAddPlayer.heldObjectTag));
    }

    @Override
    public void handleTeleportEntity(@NotNull PacketTeleportEntity packetTeleportEntity) {
        Entity entity = this.getEntityByID(packetTeleportEntity.id);
        if (entity != null) {
            entity.serverPosX = packetTeleportEntity.x;
            entity.serverPosY = packetTeleportEntity.y;
            entity.serverPosZ = packetTeleportEntity.z;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = (float)(packetTeleportEntity.yaw * 360) / 256.0f;
            float f1 = (float)(packetTeleportEntity.pitch * 360) / 256.0f;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleMoveEntity(@NotNull PacketMoveEntity packetMoveEntity) {
        Entity entity = this.getEntityByID(packetMoveEntity.id);
        if (entity != null) {
            entity.serverPosX += packetMoveEntity.x;
            entity.serverPosY += packetMoveEntity.y;
            entity.serverPosZ += packetMoveEntity.z;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = packetMoveEntity.rotating ? (float)(packetMoveEntity.yaw * 360) / 256.0f : entity.yRot;
            float f1 = packetMoveEntity.rotating ? (float)(packetMoveEntity.pitch * 360) / 256.0f : entity.xRot;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntityTagData(@NotNull PacketEntityTagData packetEntityTagData) {
        Entity entity = this.getEntityByID(packetEntityTagData.entityId);
        if (entity != null) {
            entity.readAdditionalSaveData(packetEntityTagData.tag);
        }
    }

    @Override
    public void handleSetMobSpawner(@NotNull PacketSetMobSpawner packetSetMobSpawner) {
        TileEntity tileentity;
        if (this.mc.currentWorld.isBlockLoaded(packetSetMobSpawner.tilePos) && (tileentity = this.mc.currentWorld.getTileEntity(packetSetMobSpawner.tilePos)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
            NamespaceID namespaceID = packetSetMobSpawner.dispatcherEntry != null ? packetSetMobSpawner.dispatcherEntry.namespaceID : null;
            spawner.setMobId(namespaceID == null ? "none" : namespaceID.toString());
            spawner.setChanged();
        }
    }

    @Override
    public void handleSetHotbarOffset(@NotNull PacketSetHotbarOffset packetSetHotbarOffset) {
        this.mc.thePlayer.inventory.setHotbarOffset(packetSetHotbarOffset.hotbarOffset, true);
    }

    @Override
    public void handleRemoveEntity(@NotNull PacketRemoveEntity packetRemoveEntity) {
        this.worldClientMP.removeEntityFromWorld(packetRemoveEntity.entityId);
    }

    @Override
    public void handleMovePlayer(@NotNull PacketMovePlayer packetMovePlayer) {
        PlayerLocal entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.x;
        double d1 = entityplayersp.y;
        double d2 = entityplayersp.z;
        float f = entityplayersp.yRot;
        float f1 = entityplayersp.xRot;
        if (packetMovePlayer.hasPosition) {
            d = packetMovePlayer.x;
            d1 = packetMovePlayer.y;
            d2 = packetMovePlayer.z;
        }
        if (packetMovePlayer.hasRotation) {
            f = packetMovePlayer.yaw;
            f1 = packetMovePlayer.pitch;
        }
        entityplayersp.ySlideOffset = 0.0f;
        entityplayersp.zd = 0.0;
        entityplayersp.yd = 0.0;
        entityplayersp.xd = 0.0;
        entityplayersp.absMoveTo(d, d1, d2, f, f1);
        packetMovePlayer.x = entityplayersp.x;
        packetMovePlayer.y = entityplayersp.bb.minY;
        packetMovePlayer.z = entityplayersp.z;
        this.netManager.addToSendQueue(packetMovePlayer);
        if (!this.started) {
            this.mc.thePlayer.xo = this.mc.thePlayer.x;
            this.mc.thePlayer.yo = this.mc.thePlayer.y;
            this.mc.thePlayer.zo = this.mc.thePlayer.z;
            this.started = true;
            this.mc.displayScreen(null);
        }
    }

    @Override
    public void handleChunkVisibility(@NotNull PacketChunkVisibility packetChunkVisibility) {
        this.worldClientMP.doPreChunk(packetChunkVisibility.chunkX, packetChunkVisibility.chunkZ, packetChunkVisibility.playerAdded);
    }

    @Override
    public void handleChunkBlocksUpdate(@NotNull PacketChunkBlocksUpdate packetChunkBlocksUpdate) {
        int xBase = packetChunkBlocksUpdate.xChunk * 16;
        int zBase = packetChunkBlocksUpdate.zChunk * 16;
        for (int k = 0; k < packetChunkBlocksUpdate.size; ++k) {
            int coord = packetChunkBlocksUpdate.coordinateArray[k];
            int type = packetChunkBlocksUpdate.typeArray[k] & 0x3FFF;
            byte data = packetChunkBlocksUpdate.metadataArray[k];
            int x = coord >> 0 & 0xF;
            int y = coord >> 8 & 0xFF;
            int z = coord >> 4 & 0xF;
            this.worldClientMP.setBlockAndMetadataWithNotify(x + xBase, y, z + zBase, type, data);
            this.worldClientMP.removePositionTypesInBounds(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
            this.worldClientMP.markBlocksDirty(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
        }
    }

    @Override
    public void handleBlockRegionUpdate(@NotNull PacketBlockRegionUpdate packetBlockRegionUpdate) {
        for (int x = packetBlockRegionUpdate.xPosition / 16; x <= packetBlockRegionUpdate.xPosition / 16 + packetBlockRegionUpdate.xSize / 16; ++x) {
            for (int z = packetBlockRegionUpdate.zPosition / 16; z <= packetBlockRegionUpdate.zPosition / 16 + packetBlockRegionUpdate.zSize / 16; ++z) {
                this.worldClientMP.doPreChunk(x, z, true);
            }
        }
        this.worldClientMP.removePositionTypesInBounds(packetBlockRegionUpdate.xPosition, packetBlockRegionUpdate.yPosition, packetBlockRegionUpdate.zPosition, packetBlockRegionUpdate.xPosition + packetBlockRegionUpdate.xSize - 1, packetBlockRegionUpdate.yPosition + packetBlockRegionUpdate.ySize - 1, packetBlockRegionUpdate.zPosition + packetBlockRegionUpdate.zSize - 1);
        this.worldClientMP.setChunkData(packetBlockRegionUpdate.xPosition, packetBlockRegionUpdate.yPosition, packetBlockRegionUpdate.zPosition, packetBlockRegionUpdate.xSize, packetBlockRegionUpdate.ySize, packetBlockRegionUpdate.zSize, packetBlockRegionUpdate.chunk);
    }

    @Override
    public void handleBlockUpdate(@NotNull PacketBlockUpdate packetBlockUpdate) {
        this.worldClientMP.blockChange(packetBlockUpdate.xPosition, packetBlockUpdate.yPosition, packetBlockUpdate.zPosition, packetBlockUpdate.blockId, packetBlockUpdate.metadata);
    }

    @Override
    public void handleDisconnect(@NotNull PacketDisconnect packetDisconnect) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld(null);
        this.mc.displayScreen(new ScreenConnectFailed("disconnect.disconnected", "disconnect.genericReason", new Object[]{packetDisconnect.reason}));
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        if (!this.disconnected) {
            this.disconnected = true;
            try {
                this.mc.changeWorld(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving world!", e);
            }
            try {
                this.mc.displayScreen(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving GUI!", e);
            }
            this.mc.displayScreen(new ScreenConnectFailed("disconnect.lost", message, objects));
        }
    }

    public void sendFinalPacket(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
            this.netManager.serverShutdown();
        }
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleTakeItemEntity(@NotNull PacketTakeItemEntity packetTakeItemEntity) {
        Entity item = this.getEntityByID(packetTakeItemEntity.collectedEntityId);
        Entity collector = this.getEntityByID(packetTakeItemEntity.collectorEntityId);
        if (collector == null) {
            collector = this.mc.thePlayer;
        }
        if (item != null) {
            this.worldClientMP.playSoundAtEntity(null, item, "item.pickup", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 4.0f);
            this.mc.particleEngine.add(new ParticlePickupAnimation(this.mc.currentWorld, item, collector, -0.5f));
            this.worldClientMP.removeEntityFromWorld(packetTakeItemEntity.collectedEntityId);
        }
    }

    @Override
    public void handleChat(@NotNull PacketChat packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.clientKeyChain);
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        int type = packet.type;
        if (type == 1) {
            this.mc.hudIngame.heldItemTooltipElement.setString(message);
        } else {
            this.mc.hudIngame.addChatMessage(message);
        }
    }

    public void handlePlayerJoin(PacketChat chatPacket) {
        this.mc.hudIngame.addChatMessage(chatPacket.message);
    }

    public void handlePlayerLeave(PacketChat chatPacket) {
        this.mc.hudIngame.addChatMessage(chatPacket.message);
    }

    @Override
    public void handleAnimation(@NotNull PacketAnimate packetAnimate) {
        Entity entity = this.getEntityByID(packetAnimate.entityId);
        if (entity == null) {
            return;
        }
        if (packetAnimate.animate == 1) {
            Player entityplayer = (Player)entity;
            entityplayer.swingItem();
        } else if (packetAnimate.animate == 2) {
            entity.animateHurt();
        } else if (packetAnimate.animate == 3) {
            Player player = (Player)entity;
            player.wakeUpPlayer(false, false);
        } else if (packetAnimate.animate == 4) {
            Player player = (Player)entity;
            player.animate4();
        }
    }

    @Override
    public void handleBoatControl(@NotNull PacketBoatControl packetBoatControl) {
        Entity e = this.worldClientMP.getEntityFromId(packetBoatControl.entityId);
        if (e instanceof EntityBoat) {
            ((EntityBoat)e).handleControlDirect(packetBoatControl.targetXD, packetBoatControl.targetZD, packetBoatControl.targetYRot);
        }
    }

    @Override
    public void handleSleep(@NotNull PacketSleep packetSleep) {
        Entity entity = this.getEntityByID(packetSleep.entityID);
        if (entity == null) {
            return;
        }
        if (packetSleep.field_22046_e == 0) {
            Player entityplayer = (Player)entity;
            entityplayer.sleepInBedAt(packetSleep.x, packetSleep.y, packetSleep.z);
        }
    }

    @Override
    public void handleHandshake(@NotNull PacketHandshake packetHandshake) {
        block8: {
            if (packetHandshake.username.equals("-")) {
                try {
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    this.addToSendQueue(new PacketLogin(this.mc.session.username, this.mc.session.uuid, 65312, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + packetHandshake.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    try {
                        RSA.RSAKeyChain = RSA.generateKeyPair();
                        this.addToSendQueue(new PacketLogin(this.mc.session.username, this.mc.session.uuid, 65312, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while creating LoginPacket!", e);
                    }
                }
                this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s});
            }
            catch (Exception exception) {
                LOGGER.error("Login Exception!", exception);
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + String.valueOf(exception)});
            }
        }
    }

    @Override
    public void handleAESSendKey(@NotNull PacketAESSendKey packetAESSendKey) {
        try {
            AES.clientKeyChain = AES.getKey(RSA.decrypt(packetAESSendKey.KEY, RSA.RSAKeyChain.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get AES key!", e);
        }
    }

    @Override
    public void handlePlayerList(@NotNull PacketPlayerList packetPlayerList) {
        this.playerList.clear();
        String[] players = packetPlayerList.players;
        String[] scores = packetPlayerList.scores;
        for (int i = 0; i < players.length; ++i) {
            this.playerList.put(players[i], scores[i]);
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleAddMob(@NotNull PacketAddMob packetAddMob) {
        double d = (double)packetAddMob.x / 32.0;
        double d1 = (double)packetAddMob.y / 32.0;
        double d2 = (double)packetAddMob.z / 32.0;
        float f = (float)(packetAddMob.yaw * 360) / 256.0f;
        float f1 = (float)(packetAddMob.pitch * 360) / 256.0f;
        Mob mob = (Mob)EntityDispatcher.getInstance().createEntity(packetAddMob.type, this.mc.currentWorld);
        mob.serverPosX = packetAddMob.x;
        mob.serverPosY = packetAddMob.y;
        mob.serverPosZ = packetAddMob.z;
        mob.id = packetAddMob.id;
        mob.absMoveTo(d, d1, d2, f, f1);
        mob.isMultiplayerEntity = true;
        this.worldClientMP.addEntityToWorld(packetAddMob.id, mob);
        List<SynchedEntityData.DataItem<?>> list = packetAddMob.getUnpackedData();
        if (list != null) {
            mob.getEntityData().assignValues(list);
        }
        mob.nickname = StringUtils.substring(packetAddMob.nickname, 0, 32);
        mob.chatColor = packetAddMob.chatColor;
    }

    @Override
    public void handleSetTime(@NotNull PacketSetTime packetSetTime) {
        this.mc.currentWorld.setWorldTime(packetSetTime.time);
    }

    @Override
    public void handleSetSpawnPosition(@NotNull PacketSetSpawnPosition packetSetSpawnPosition) {
        this.mc.thePlayer.setPlayerSpawnPoint(new TilePos(packetSetSpawnPosition.x, packetSetSpawnPosition.y, packetSetSpawnPosition.z));
        this.mc.currentWorld.getLevelData().setSpawn(packetSetSpawnPosition.x, packetSetSpawnPosition.y, packetSetSpawnPosition.z);
    }

    @Override
    public void handleSetRiding(@NotNull PacketSetRiding packetSetRiding) {
        Entity passenger = this.getEntityByID(packetSetRiding.passengerId);
        if (packetSetRiding.passengerId == this.mc.thePlayer.id) {
            passenger = this.mc.thePlayer;
        }
        IVehicle vehicle = packetSetRiding.isTileEntity ? (IVehicle)((Object)this.worldClientMP.getTileEntity(packetSetRiding.x, packetSetRiding.y, packetSetRiding.z)) : this.getEntityByID(packetSetRiding.vehicleId);
        if (passenger != null && vehicle != null) {
            passenger.startRiding(vehicle);
        }
    }

    @Override
    public void handleEntityEvent(@NotNull PacketEntityEvent packetEntityEvent) {
        Entity entity = this.getEntityByID(packetEntityEvent.entityId);
        if (entity != null) {
            entity.handleEntityEvent(packetEntityEvent.entityStatus, packetEntityEvent.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i) {
        if (i == this.mc.thePlayer.id) {
            return this.mc.thePlayer;
        }
        return this.worldClientMP.getEntityFromId(i);
    }

    @Override
    public void handleSetHealth(@NotNull PacketSetHealth packetSetHealth) {
        this.mc.thePlayer.setHealth(packetSetHealth.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(@NotNull PacketUpdatePlayerProfile profilePacket) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(profilePacket.username, profilePacket.nickname, profilePacket.uuid, profilePacket.score, profilePacket.chatColor, profilePacket.isOperator);
        if (playerProfile.uuid.equals(this.mc.thePlayer.uuid)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!profilePacket.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(@NotNull PacketRespawn packetRespawn) {
        if (packetRespawn.respawnDimensionId != this.mc.thePlayer.dimension) {
            this.started = false;
            this.worldClientMP = new WorldClientMP(this, this.worldClientMP.getLevelData().getRandomSeed(), packetRespawn.respawnDimensionId, packetRespawn.respawnWorldTypeId);
            this.worldClientMP.isClientSide = true;
            this.mc.changeWorld(this.worldClientMP);
            this.mc.thePlayer.dimension = packetRespawn.respawnDimensionId;
            this.mc.displayScreen(new ScreenDownloadTerrain(this));
        }
        this.mc.respawn(true, packetRespawn.respawnDimensionId);
    }

    @Override
    public void handleExplosion(@NotNull PacketExplosion packetExplosion) {
        Explosion explosion = packetExplosion.isCannonball ? new ExplosionCannonball(this.mc.currentWorld, null, packetExplosion.explosionX, packetExplosion.explosionY, packetExplosion.explosionZ, packetExplosion.explosionSize) : new Explosion(this.mc.currentWorld, null, packetExplosion.explosionX, packetExplosion.explosionY, packetExplosion.explosionZ, packetExplosion.explosionSize);
        explosion.destroyedBlockPositions = packetExplosion.destroyedBlockPositions;
        explosion.addEffects(true);
    }

    @Override
    public void handleContainerOpen(@NotNull PacketContainerOpen packetContainerOpen) {
        switch (packetContainerOpen.inventoryType) {
            case 0: {
                ContainerSimple simpleContainer = new ContainerSimple(packetContainerOpen.windowTitle, packetContainerOpen.slotsCount);
                this.mc.thePlayer.displayContainerScreen(simpleContainer);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 2: {
                TileEntityFurnace tileEntityFurnace = new TileEntityFurnace();
                this.mc.thePlayer.displayFurnaceScreen(tileEntityFurnace);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 3: {
                TileEntityDispenser tileEntityDispenser = new TileEntityDispenser();
                this.mc.thePlayer.displayDispenserScreen(tileEntityDispenser);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 6: {
                TileEntityActivator tileEntityActivator = new TileEntityActivator();
                this.mc.thePlayer.displayActivatorScreen(tileEntityActivator);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 4: {
                TileEntityFurnaceBlast tileEntityFurnaceBlast = new TileEntityFurnaceBlast();
                this.mc.thePlayer.displayBlastFurnaceScreen(tileEntityFurnaceBlast);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 5: {
                TileEntityTrommel tileEntityTrommel = new TileEntityTrommel();
                this.mc.thePlayer.displayTrommelScreen(tileEntityTrommel);
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            case 7: {
                this.mc.thePlayer.displayPaintingPickerScreen();
                break;
            }
            case 1: {
                PlayerLocal playerLocal = this.mc.thePlayer;
                this.mc.thePlayer.displayWorkbenchScreen(new TilePos(playerLocal.x, playerLocal.y, playerLocal.z));
                this.mc.thePlayer.craftingInventory.containerId = packetContainerOpen.windowId;
                break;
            }
            default: {
                LOGGER.warn("No defined before for container open '{}' with type {}!", (Object)packetContainerOpen.windowId, (Object)packetContainerOpen.inventoryType);
            }
        }
    }

    @Override
    public void handleFlagOpen(@NotNull PacketFlagOpen packetFlagOpen) {
        TileEntity tileEntity = this.worldClientMP.getTileEntity(packetFlagOpen.x, packetFlagOpen.y, packetFlagOpen.z);
        if (tileEntity instanceof TileEntityFlag) {
            TileEntityFlag tileEntityFlag = (TileEntityFlag)tileEntity;
            this.mc.thePlayer.displayFlagEditorScreen(tileEntityFlag);
            this.mc.thePlayer.craftingInventory.containerId = packetFlagOpen.windowId;
        }
    }

    @Override
    public void handlePhotoMode(@NotNull PacketPhotoMode packetPhotoMode) {
        ScreenPause.photoModeDisabled = packetPhotoMode.disabled;
    }

    @Override
    public void handleContainerSetSlot(@NotNull PacketContainerSetSlot packetContainerSetSlot) {
        if (packetContainerSetSlot.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(packetContainerSetSlot.myItemStack);
        } else if (packetContainerSetSlot.windowId == 0 && packetContainerSetSlot.itemSlot >= 36 && packetContainerSetSlot.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(packetContainerSetSlot.itemSlot).getItemStack();
            if (packetContainerSetSlot.myItemStack != null && (itemstack == null || itemstack.stackSize < packetContainerSetSlot.myItemStack.stackSize)) {
                packetContainerSetSlot.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.setItem(packetContainerSetSlot.itemSlot, packetContainerSetSlot.myItemStack);
        } else if (packetContainerSetSlot.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setItem(packetContainerSetSlot.itemSlot, packetContainerSetSlot.myItemStack);
        }
    }

    @Override
    public void handleContainerAck(@NotNull PacketContainerAck packetContainerAck) {
        MenuAbstract container = null;
        if (packetContainerAck.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (packetContainerAck.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (packetContainerAck.accepted) {
                container.deleteBackup(packetContainerAck.shortWindowId);
            } else {
                container.rollbackToBackup(packetContainerAck.shortWindowId);
                this.addToSendQueue(new PacketContainerAck(packetContainerAck.windowId, packetContainerAck.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleContainerSetContent(@NotNull PacketContainerSetContent packetContainerSetContent) {
        if (packetContainerSetContent.windowId == 0) {
            this.mc.thePlayer.inventorySlots.setAll(packetContainerSetContent.stackList);
        } else if (packetContainerSetContent.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setAll(packetContainerSetContent.stackList);
        }
    }

    @Override
    public void handleContainerSetData(@NotNull PacketContainerSetData packetContainerSetData) {
        this.handleInvalidPacket(packetContainerSetData);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.containerId == packetContainerSetData.windowId) {
            this.mc.thePlayer.craftingInventory.setData(packetContainerSetData.progressBar, packetContainerSetData.progressBarValue);
        }
    }

    @Override
    public void handleSetEquippedItem(@NotNull PacketSetEquippedItem packetSetEquippedItem) {
        Entity entity = this.getEntityByID(packetSetEquippedItem.entityID);
        if (entity != null) {
            entity.setEquippedSlot(packetSetEquippedItem.slot, packetSetEquippedItem.itemID, packetSetEquippedItem.itemMeta, packetSetEquippedItem.itemData);
        }
    }

    @Override
    public void handleSetHeldObject(@NotNull PacketSetHeldObject packetSetHeldObject) {
        Entity entity = this.getEntityByID(packetSetHeldObject.entityID);
        if (entity != null) {
            entity.setHeldObject(packetSetHeldObject.objectTag == null ? null : ICarriable.createAndLoadCarriable(entity, packetSetHeldObject.objectTag));
        }
    }

    @Override
    public void handleContainerClose(@NotNull PacketContainerClose packetContainerClose) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handleBlockEvent(@NotNull PacketBlockEvent packetBlockEvent) {
        this.mc.currentWorld.triggerEvent(packetBlockEvent.xLocation, packetBlockEvent.yLocation, packetBlockEvent.zLocation, packetBlockEvent.index, packetBlockEvent.data);
    }

    @Override
    public void handleBedMessage(@NotNull PacketBedMessage packetBedMessage) {
        int state = packetBedMessage.bedState;
        if (state >= 0 && state < PacketBedMessage.BED_MESSAGE_KEYS.length && PacketBedMessage.BED_MESSAGE_KEYS[state] != null) {
            this.mc.thePlayer.sendTranslatedChatMessage(PacketBedMessage.BED_MESSAGE_KEYS[state]);
        }
    }

    @Override
    public void handleMapData(@NotNull PacketMapData packetMapData) {
        if (packetMapData.itemId == Items.MAP.id) {
            ItemMap.getOrCreateSavedData(packetMapData.meta, packetMapData.scale, this.mc.currentWorld).setColors(packetMapData.mapData).setMapWaypoints(packetMapData.waypoints);
        } else {
            LOGGER.warn("Unexpected itemId: {}", (Object)packetMapData.itemId);
        }
    }

    @Override
    public void handlePlaySoundEffect(@NotNull PacketPlaySound packetPlaySound) {
        this.mc.currentWorld.playBlockEvent(packetPlaySound.soundID, packetPlaySound.x, packetPlaySound.y, packetPlaySound.z, packetPlaySound.data);
    }

    @Override
    public void handlePlaySoundDirectly(@NotNull PacketPlaySoundDirect packet) {
        String soundPath = SoundTypes.getSoundById(packet.soundId);
        if (soundPath == null) {
            return;
        }
        this.mc.sndManager.playSoundAt(soundPath, packet.soundType, (float)packet.x, (float)packet.y, (float)packet.z, packet.volume, packet.pitch);
    }

    @Override
    public void handleAddParticle(@NotNull PacketAddParticle packetAddParticle) {
        if (packetAddParticle.isGroup) {
            for (int i = 0; i < packetAddParticle.amount; ++i) {
                this.mc.renderGlobal.addParticle(packetAddParticle.particleKey, packetAddParticle.x + this.rand.nextDouble() * (double)packetAddParticle.randOffX, packetAddParticle.y + this.rand.nextDouble() * (double)packetAddParticle.randOffY, packetAddParticle.z + this.rand.nextDouble() * (double)packetAddParticle.randOffZ, packetAddParticle.motionX + this.rand.nextGaussian() * (double)packetAddParticle.randMotionX, packetAddParticle.motionY + this.rand.nextGaussian() * (double)packetAddParticle.randMotionY, packetAddParticle.motionZ + this.rand.nextGaussian() * (double)packetAddParticle.randMotionZ, packetAddParticle.data, packetAddParticle.maxDistance);
            }
        } else {
            this.mc.renderGlobal.addParticle(packetAddParticle.particleKey, packetAddParticle.x, packetAddParticle.y, packetAddParticle.z, packetAddParticle.motionX, packetAddParticle.motionY, packetAddParticle.motionZ, packetAddParticle.data, packetAddParticle.maxDistance);
        }
    }

    @Override
    public void handleStatistic(@NotNull PacketStatistic packetStatistic) {
        NamespaceID id;
        try {
            id = NamespaceID.fromPool(packetStatistic.statID);
        }
        catch (HardIllegalArgumentException e) {
            LOGGER.error("Received invalid stat id '{}' from server!", (Object)packetStatistic.statID);
            return;
        }
        Stat stat = StatList.getStat(id);
        if (stat == null) {
            LOGGER.error("Could not find stat for id '{}' from server!", (Object)id);
            return;
        }
        if (stat.clientside) {
            return;
        }
        this.mc.thePlayer.addStat(stat, packetStatistic.valueChange);
    }

    @Override
    public void handlePlayerGamemode(@NotNull PacketPlayerGamemode packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity instanceof Player) {
            ((Player)entity).setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
        }
    }

    @Override
    public void handleEntityNickname(@NotNull PacketEntityNickname packetEntityNickname) {
        Entity entity = this.getEntityByID(packetEntityNickname.entityId);
        if (entity instanceof Mob) {
            ((Mob)entity).nickname = StringUtils.substring(packetEntityNickname.nickname, 0, 32);
            ((Mob)entity).chatColor = packetEntityNickname.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleSetCarriedItem(@NotNull PacketSetCarriedItem packetSetCarriedItem) {
        this.mc.thePlayer.inventory.setCurrentItemIndex(packetSetCarriedItem.id, true);
    }

    @Override
    public void handleTileEntityData(@NotNull PacketTileEntityData packetTileEntityData) {
        Class<? extends TileEntity> clazz = TileEntityDispatcher.getClassFromID(packetTileEntityData.tag.getString("id"));
        if (clazz == null) {
            return;
        }
        TileEntity existingTileEntity = this.worldClientMP.getTileEntity(packetTileEntityData.tag.getInteger("x"), packetTileEntityData.tag.getInteger("y"), packetTileEntityData.tag.getInteger("z"));
        if (existingTileEntity == null || existingTileEntity.getClass() != clazz) {
            TileEntity tileEntity = TileEntityDispatcher.createAndLoadEntity(packetTileEntityData.tag);
            if (tileEntity != null) {
                this.mc.currentWorld.setTileEntity(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity);
            }
        } else {
            existingTileEntity.readFromNBT(packetTileEntityData.tag);
        }
        this.worldClientMP.markBlockDirty(packetTileEntityData.tag.getInteger("x"), packetTileEntityData.tag.getInteger("y"), packetTileEntityData.tag.getInteger("z"));
    }

    @Override
    public void handleGameRule(@NotNull PacketGameRule packet) {
        LevelData levelData = this.mc.currentWorld.getLevelData();
        if (packet.getGameRules() != null) {
            levelData.getGameRules().setValues(packet.getGameRules());
        }
    }

    @Override
    public void handleRecipeSync(@NotNull PacketRecipeSync packetRecipeSync) {
        if (Registries.RECIPES.getAllSerializableRecipes().isEmpty()) {
            LOGGER.info("Receiving {} recipes from server..", (Object)packetRecipeSync.maxRecipes);
        }
        DataLoader.loadRecipeFromServer(packetRecipeSync);
        if ((long)Registries.RECIPES.getAllSerializableRecipes().size() == packetRecipeSync.maxRecipes) {
            LOGGER.info("All recipes received!");
            Registries.RECIPES.invalidateCaches();
            GuidebookPageSearch.searchField.setText("_");
            GuidebookPageManager.searchQuery = SearchQuery.resolve(GuidebookPageSearch.searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
            GuidebookPageSearch.searchField.setText("");
            GuidebookPageManager.searchQuery = SearchQuery.resolve(GuidebookPageSearch.searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
        }
    }

    @Override
    public void handleSyncIDs(@NotNull PacketSyncIDs packetSyncIDs) {
        if (packetSyncIDs.destinationId == 0) {
            SoundTypes.setSoundIds(packetSyncIDs.mapping);
        } else if (packetSyncIDs.destinationId == 1) {
            EntityDispatcher.getInstance().setNumericIds(packetSyncIDs.mapping);
        }
    }

    @Override
    public void handleCustomPayload(@NotNull PacketCustomPayload packetCustomPayload) {
        if ("BTA:RainbowStart".equals(packetCustomPayload.channel)) {
            int rainbowTicks = Byte.toUnsignedInt(packetCustomPayload.data[0]) << 24 | Byte.toUnsignedInt(packetCustomPayload.data[1]) << 16 | Byte.toUnsignedInt(packetCustomPayload.data[2]) << 8 | Byte.toUnsignedInt(packetCustomPayload.data[3]);
            this.worldClientMP.addRainbow(rainbowTicks);
        }
    }

    @Override
    public void handleCommandManager(@NotNull PacketCommandManager packetCommandManager) {
        GuiElementChatSuggestions.serverSuggestions = packetCommandManager.suggestions;
    }
}

