/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.FloatBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;

public class FogManager {
    public static final int FOG_MODE_SKY = -1;
    public static final int FOG_MODE_NORMAL = 0;
    @NotNull
    public final Minecraft mc;
    public float fogRed;
    public float fogGreen;
    public float fogBlue;
    public float fogBrightnessOld;
    public float fogBrightness;
    @NotNull
    private final FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);

    public FogManager(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    public void updateBrightness() {
        this.fogBrightnessOld = this.fogBrightness;
        float fogModifier = this.mc.currentWorld.getCurrentWeather() != null ? this.mc.currentWorld.getCurrentWeather().getFogDistanceMultiplier() : 1.0f;
        fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower();
        float brightnessAtCamera = this.mc.currentWorld.getLightBrightness(this.mc.activeCamera.getTilePos());
        if (this.mc.fullbright) {
            brightnessAtCamera = 1.0f;
        }
        float renderDistanceModifier = (float)(this.mc.gameSettings.renderDistance.highest - (Integer)this.mc.gameSettings.renderDistance.value) * fogModifier / (float)this.mc.gameSettings.renderDistance.highest;
        float newBrightness = brightnessAtCamera * (1.0f - renderDistanceModifier) + renderDistanceModifier;
        this.fogBrightness += (newBrightness - this.fogBrightness) * 0.1f;
    }

    public void setupFog(int fogMode, float farPlaneDistance, float partialTick) {
        GL11.glFogfv(2918, this.buffer(this.fogRed, this.fogGreen, this.fogBlue, 0.5f));
        GL11.glNormal3f(0.0f, -1.0f, 0.0f);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue() && fogMode != -1) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.0f);
            float maxFogDistance = this.mc.gameSettings.renderDistance.highest * 16;
            GL11.glFogf(2915, maxFogDistance * 0.25f);
            GL11.glFogf(2916, maxFogDistance);
            GL11.glEnable(2903);
            GL11.glColorMaterial(1028, 4608);
            return;
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTick)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.1f);
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.LAVA, partialTick)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 2.0f);
        } else {
            float fogDistance = farPlaneDistance;
            float maxFogDistance = this.mc.gameSettings.renderDistance.highest * 16;
            float fogModifier = this.mc.currentWorld.getCurrentWeather() != null ? this.mc.currentWorld.getCurrentWeather().getFogDistanceMultiplier() : 1.0f;
            if (fogDistance > maxFogDistance * (fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower())) {
                fogDistance = maxFogDistance * fogModifier;
            }
            if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                fogDistance = farPlaneDistance * ((ScreenPhotoMode)this.mc.currentScreen).getFog(partialTick);
            }
            GL11.glFogi(2917, 9729);
            GL11.glFogf(2915, fogDistance * 0.25f * fogModifier);
            GL11.glFogf(2916, fogDistance);
            GL11.glFogf(2914, 1.0f);
            if (fogMode == -1) {
                GL11.glFogf(2915, 0.0f);
                GL11.glFogf(2916, fogDistance * 0.8f);
            }
            if (OpenGLHelper.enableSphericalFog) {
                GL11.glFogi(34138, 34139);
            }
            if (this.mc.currentWorld.dimension == Dimension.NETHER) {
                GL11.glFogf(2915, 0.0f);
            }
        }
        GL11.glEnable(2903);
        GL11.glColorMaterial(1028, 4608);
    }

    public void updateFogColor(float partialTick) {
        WorldClient world = this.mc.currentWorld;
        float renderDistanceScale = 1.0f / (float)(this.mc.gameSettings.renderDistance.highest + 8 - (Integer)this.mc.gameSettings.renderDistance.value);
        renderDistanceScale = 1.0f - (float)Math.pow(renderDistanceScale, 0.25);
        Vector3fc skyColor = world.getSkyColor(this.mc.activeCamera, partialTick);
        float rSky = skyColor.x();
        float gSky = skyColor.y();
        float bSky = skyColor.z();
        Vector3fc worldColor = world.getFogColor(this.mc.activeCamera, partialTick);
        this.fogRed = worldColor.x();
        this.fogGreen = worldColor.y();
        this.fogBlue = worldColor.z();
        this.fogRed += (rSky - this.fogRed) * renderDistanceScale;
        this.fogGreen += (gSky - this.fogGreen) * renderDistanceScale;
        this.fogBlue += (bSky - this.fogBlue) * renderDistanceScale;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogRed, this.fogGreen, this.fogBlue, world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower());
            this.fogRed = out[0];
            this.fogGreen = out[1];
            this.fogBlue = out[2];
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Materials.WATER, partialTick)) {
            this.fogRed = 0.02f;
            this.fogGreen = 0.02f;
            this.fogBlue = 0.2f;
            if (((Boolean)this.mc.gameSettings.biomeWater.value).booleanValue()) {
                TilePos cameraTile = this.mc.activeCamera.getTilePos();
                double temp = world.getBlockTemperature(cameraTile);
                double humid = world.getBlockHumidity(cameraTile);
                int waterColor = Colorizers.water.getColor(temp, humid);
                float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(waterColor & 0xFF) / 255.0f;
                red = MathHelper.clamp(red, 0.0f, 1.0f);
                green = MathHelper.clamp(green, 0.0f, 1.0f);
                blue = MathHelper.clamp(blue, 0.0f, 1.0f);
                this.fogRed = red * 0.5f;
                this.fogGreen = green * 0.5f;
                this.fogBlue = blue * 0.5f;
            }
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Materials.LAVA, partialTick)) {
            this.fogRed = 0.6f;
            this.fogGreen = 0.1f;
            this.fogBlue = 0.0f;
        }
        float brightness = this.fogBrightnessOld + (this.fogBrightness - this.fogBrightnessOld) * partialTick;
        this.fogRed *= brightness;
        this.fogGreen *= brightness;
        this.fogBlue *= brightness;
        Screen screen = this.mc.currentScreen;
        if (screen instanceof ScreenModelViewer) {
            ScreenModelViewer screenModelViewer = (ScreenModelViewer)screen;
            float[] color = screenModelViewer.getBackgroundFogColor();
            this.fogRed = color[0];
            this.fogGreen = color[1];
            this.fogBlue = color[2];
        }
        GL11.glClearColor(this.fogRed, this.fogGreen, this.fogBlue, 0.0f);
    }

    @NotNull
    private FloatBuffer buffer(float r, float g, float b, float a) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(r).put(g).put(b).put(a);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

