/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGeneric<T extends BlockLogic>
extends BlockModel<T> {
    private final StaticBlockModel staticModel;

    public BlockModelGeneric(@NotNull Block<T> block, @NotNull StaticBlockModel staticModel) {
        super(block);
        this.staticModel = staticModel;
    }

    public BlockModelGeneric(@NotNull Block<T> block, @NotNull BlockModelData staticModel) {
        super(block);
        this.staticModel = staticModel.asModel();
    }

    @Override
    public boolean renderNoCulling(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return this.staticModel.renderAttached(this, tessellator, worldSource, tilePos.x(), tilePos.y(), tilePos.z(), 0.0, 0.0, 0.0, false, null);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return this.staticModel.renderAttached(this, tessellator, worldSource, tilePos.x(), tilePos.y(), tilePos.z(), 0.0, 0.0, 0.0, true, null);
    }

    @Override
    public boolean renderOverbright(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean renderWithOverrideTexture(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, IconCoordinate textureIndex) {
        return this.staticModel.renderAttached(this, tessellator, worldSource, tilePos.x(), tilePos.y(), tilePos.z(), 0.0, 0.0, 0.0, true, textureIndex);
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        this.staticModel.renderStandalone(this, tessellator, 0.0, 0.0, 0.0, metadata, (BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block), brightness, alpha);
    }

    @Override
    public boolean shouldItemRender3d() {
        return true;
    }

    @Override
    @NotNull
    public DisplayPos getItemDisplayPos(@NotNull String id) {
        return this.staticModel.getItemDisplayPos(id);
    }

    @Override
    public int renderLayer() {
        return this.staticModel.renderLayer();
    }

    @Override
    @Nullable
    public IconCoordinate getParticleTexture(@NotNull Side side, int meta) {
        return this.staticModel.getParticle(side);
    }

    @Override
    @Nullable
    public IconCoordinate getOverlayTexture(int meta) {
        return this.staticModel.getOverlay();
    }

    @Override
    public int particleColorIndex(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Side side, int meta) {
        return this.staticModel.particleColorIndex(side);
    }
}

