/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicJarButterfly;
import net.minecraft.core.block.BlockLogicLanternFirefly;
import net.minecraft.core.block.BlockLogicRope;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;

public class BlockModelRope<T extends BlockLogicRope>
extends BlockModelStandard<T> {
    public BlockModelRope(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        Block<?> below = worldSource.getBlock(tilePos.down(new TilePos()));
        boolean hasFloor = below != null && below.canPlaceOnSurface();
        boolean hasBlockNegX = this.canConnect(worldSource, tilePos, Direction.WEST);
        boolean hasBlockPosX = this.canConnect(worldSource, tilePos, Direction.EAST);
        boolean hasBlockNegY = this.canConnect(worldSource, tilePos, Direction.DOWN) || hasFloor;
        boolean hasBlockPosY = this.canConnect(worldSource, tilePos, Direction.UP);
        boolean hasBlockNegZ = this.canConnect(worldSource, tilePos, Direction.NORTH);
        boolean hasBlockPosZ = this.canConnect(worldSource, tilePos, Direction.SOUTH);
        boolean drawKnot = !(hasBlockNegX && hasBlockPosX && !hasBlockNegY && !hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && hasBlockNegY && hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && !hasBlockNegY && !hasBlockPosY && hasBlockNegZ && hasBlockPosZ);
        AABBd bounds = new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        float ropeThickness = 0.0625f;
        float knotThickness = 0.125f;
        float pileWidth = 0.1875f;
        if (drawKnot) {
            bounds.setMin(0.375, 0.375, 0.375).setMax(0.625, 0.625, 0.625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockPosY) {
            bounds.setMin(0.4375, 0.5, 0.4375).setMax(0.5625, 1.0, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockNegY) {
            bounds.setMin(0.4375, 0.0, 0.4375).setMax(0.5625, 0.5, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockPosX) {
            bounds.setMin(0.5, 0.4375, 0.4375).setMax(1.0, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockNegX) {
            bounds.setMin(0.0, 0.4375, 0.4375).setMax(0.5, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockPosZ) {
            bounds.setMin(0.4375, 0.4375, 0.5).setMax(0.5625, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasBlockNegZ) {
            bounds.setMin(0.4375, 0.4375, 0.0).setMax(0.5625, 0.5625, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (hasFloor) {
            bounds.setMin(0.3125, 0.0, 0.3125).setMax(0.6875, 0.125, 0.6875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.375, 0.0, 0.375).setMax(0.625, 0.1875, 0.625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        return true;
    }

    private boolean canConnect(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Direction direction) {
        TilePos shiftedPos = tilePos.add(direction, new TilePos());
        Block<?> _block = worldSource.getBlock(shiftedPos);
        if (direction == Direction.DOWN) {
            if (Block.hasLogicClass(_block, BlockLogicLanternFirefly.class) && (worldSource.getBlockData(shiftedPos) & 1) != 0) {
                return true;
            }
            if (Block.hasLogicClass(_block, BlockLogicJarButterfly.class) && (worldSource.getBlockData(shiftedPos) & 1) != 0) {
                return true;
            }
        } else if (direction == Direction.UP && (worldSource.isBlockOpaqueCube(shiftedPos) || BlockTags.CAN_HANG_OFF.appliesTo(_block))) {
            return true;
        }
        if ((worldSource.getBlockData(tilePos) & 0x80) != 0 && worldSource.isBlockOpaqueCube(shiftedPos)) {
            return true;
        }
        return _block == this.block;
    }
}

