/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightingCache;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public final class RenderBlocks {
    public final Minecraft mc;
    public IconCoordinate overrideBlockTexture = null;
    public boolean flipTexture = false;
    public boolean renderAllFaces = false;
    public byte renderBitMask = 0;
    public boolean useInventoryTint = true;
    public int uvRotateEast = 0;
    public int uvRotateWest = 0;
    public int uvRotateSouth = 0;
    public int uvRotateNorth = 0;
    public int uvRotateTop = 0;
    public int uvRotateBottom = 0;
    public boolean enableAO;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public int lightmapCoordTopLeft;
    public int lightmapCoordBottomLeft;
    public int lightmapCoordBottomRight;
    public int lightmapCoordTopRight;
    public boolean overbright;
    public LightingCache cache = new LightingCache();

    public RenderBlocks() {
        this.mc = Minecraft.getMinecraft();
    }

    public void resetRenderBlocks() {
        this.renderAllFaces = false;
        this.enableAO = false;
        this.useInventoryTint = true;
        this.flipTexture = false;
        this.overrideBlockTexture = null;
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        this.renderBitMask = 0;
    }

    public void setRenderSide(@NotNull Side side, boolean shouldRender) {
        this.renderBitMask = !shouldRender ? (byte)(this.renderBitMask | (byte)(1 << side.getId())) : (byte)(this.renderBitMask & (byte)(~(1 << side.getId())));
    }

    @Deprecated
    public float getBlockBrightness(@NotNull WorldSource worldSource, int x, int y, int z) {
        return this.getBlockBrightness(worldSource, new TilePos(x, y, z));
    }

    public float getBlockBrightness(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        if (this.mc.fullbright) {
            return 1.0f;
        }
        int id = worldSource.getBlockId(tilePos);
        Block<?> block = worldSource.getBlock(tilePos);
        if (block != null) {
            return block.getBrightness(worldSource, tilePos);
        }
        return worldSource.getBrightness(tilePos, Blocks.lightEmission[id]);
    }

    @Deprecated
    public boolean renderStandardBlock(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, int x, int y, int z) {
        return this.renderStandardBlock(tessellator, worldSource, blockModel, bounds, new TilePos(x, y, z));
    }

    public boolean renderStandardBlock(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, @NotNull TilePosc tilePos) {
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(blockModel.block)).getWorldColor(worldSource, tilePos, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return this.renderStandardBlock(tessellator, worldSource, blockModel, bounds, tilePos, r, g, b);
    }

    @Deprecated
    public boolean renderStandardBlock(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, int x, int y, int z, float r, float g, float b) {
        return this.renderStandardBlock(tessellator, worldSource, blockModel, bounds, new TilePos(x, y, z), r, g, b);
    }

    public boolean renderStandardBlock(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, float r, float g, float b) {
        this.enableAO = true;
        int meta = worldSource.getBlockData(tilePos);
        this.cache.setupCache(blockModel.block, worldSource, tilePos);
        boolean somethingRendered = false;
        for (Side side : Side.sides) {
            somethingRendered |= this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, r, g, b, side, meta);
        }
        this.enableAO = false;
        return somethingRendered;
    }

    @Deprecated
    public boolean renderSide(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, int x, int y, int z, float r, float g, float b, @NotNull Side side, int meta) {
        return this.renderSide(tessellator, worldSource, blockModel, bounds, new TilePos(x, y, z), r, g, b, side, meta);
    }

    public boolean renderSide(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, float r, float g, float b, @NotNull Side side, int meta) {
        return switch (side) {
            case Side.BOTTOM -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, 0, -1, 0, (float)bounds.minY(), 0, 0, 1, (float)bounds.maxZ(), (float)bounds.minZ(), -1, 0, 0, 1.0f - (float)bounds.minX(), 1.0f - (float)bounds.maxX());
            }
            case Side.TOP -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, 0, 1, 0, 1.0f - (float)bounds.maxY(), 0, 0, 1, (float)bounds.maxZ(), (float)bounds.minZ(), 1, 0, 0, (float)bounds.maxX(), (float)bounds.minX());
            }
            case Side.NORTH -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, 0, 0, -1, (float)bounds.minZ(), -1, 0, 0, 1.0f - (float)bounds.minX(), 1.0f - (float)bounds.maxX(), 0, 1, 0, (float)bounds.maxY(), (float)bounds.minY());
            }
            case Side.SOUTH -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, 0, 0, 1, 1.0f - (float)bounds.maxZ(), 0, 1, 0, (float)bounds.maxY(), (float)bounds.minY(), -1, 0, 0, 1.0f - (float)bounds.minX(), 1.0f - (float)bounds.maxX());
            }
            case Side.WEST -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, -1, 0, 0, (float)bounds.minX(), 0, 0, 1, (float)bounds.maxZ(), (float)bounds.minZ(), 0, 1, 0, (float)bounds.maxY(), (float)bounds.minY());
            }
            case Side.EAST -> {
                boolean useColor = blockModel.shouldSideBeColored(worldSource, tilePos, side, meta);
                yield this.renderSide(tessellator, worldSource, blockModel, bounds, tilePos, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, side, meta, 1, 0, 0, 1.0f - (float)bounds.maxX(), 0, 0, 1, (float)bounds.maxZ(), (float)bounds.minZ(), 0, -1, 0, 1.0f - (float)bounds.minY(), 1.0f - (float)bounds.maxY());
            }
            default -> throw new IllegalArgumentException("Side " + String.valueOf((Object)side) + " not expected!");
        };
    }

    public boolean renderSide(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull BlockModelStandard<?> blockModel, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, float r, float g, float b, @NotNull Side side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        IconCoordinate tex = this.overbright ? blockModel.getBlockOverbrightTexture(worldSource, tilePos, side) : blockModel.getBlockTexture(worldSource, tilePos, side);
        if (tex == null || (this.renderBitMask >> side.getId() & 1) != 0) {
            return false;
        }
        boolean rendered = false;
        if (this.renderAllFaces || blockModel.shouldSideBeRendered(worldSource, bounds, tilePos.add(dirX, dirY, dirZ, new TilePos()), side, meta)) {
            this.setupLighting(worldSource, blockModel.block, tilePos, r, g, b, side, dirX, dirY, dirZ, depth, topX, topY, topZ, topP, botP, lefX, lefY, lefZ, lefP, rigP);
            switch (side) {
                case BOTTOM: {
                    this.renderBottomFace(tessellator, bounds, tilePos, tex);
                    break;
                }
                case TOP: {
                    this.renderTopFace(tessellator, bounds, tilePos, tex);
                    break;
                }
                case NORTH: {
                    this.renderNorthFace(tessellator, bounds, tilePos, tex);
                    break;
                }
                case SOUTH: {
                    this.renderSouthFace(tessellator, bounds, tilePos, tex);
                    break;
                }
                case WEST: {
                    this.renderWestFace(tessellator, bounds, tilePos, tex);
                    break;
                }
                case EAST: {
                    this.renderEastFace(tessellator, bounds, tilePos, tex);
                }
            }
            rendered = true;
        }
        return rendered;
    }

    public void setupLighting(@NotNull WorldSource worldSource, @NotNull Block<?> block, @NotNull TilePosc tilePos, float r, float g, float b, @NotNull Side side, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        float lightTL;
        float lightBL;
        float lightBR;
        float lightTR;
        boolean lefT;
        boolean isFullCube;
        boolean ao = this.mc.isAmbientOcclusionEnabled() && block.emission == 0;
        boolean bl = isFullCube = depth <= 0.0625f;
        if (LightmapHelper.isLightmapEnabled()) {
            if (this.overbright) {
                int lmc;
                dirX2 = dirX;
                dirY2 = dirY;
                dirZ2 = dirZ;
                if (!isFullCube) {
                    dirX2 = 0;
                    dirY2 = 0;
                    dirZ2 = 0;
                }
                this.lightmapCoordBottomRight = this.lightmapCoordTopRight = (lmc = LightmapHelper.getOverbrightLightmapCoord(worldSource.getSavedLightValue(LightLayer.Sky, dirX2, dirY2, dirZ2)));
                this.lightmapCoordBottomLeft = this.lightmapCoordTopRight;
                this.lightmapCoordTopLeft = this.lightmapCoordTopRight;
            } else if (ao) {
                int lmcTopRig;
                int lmcBotLef;
                int lmcTopLef;
                int lmcRig;
                dirX2 = dirX;
                dirY2 = dirY;
                dirZ2 = dirZ;
                if (!isFullCube) {
                    dirX2 = 0;
                    dirY2 = 0;
                    dirZ2 = 0;
                }
                boolean topT = this.cache.getOpacity(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                boolean botT = this.cache.getOpacity(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                lefT = this.cache.getOpacity(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                boolean rigT = this.cache.getOpacity(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                boolean topLefT = this.cache.getOpacity(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ);
                boolean topRigT = this.cache.getOpacity(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ);
                boolean botLefT = this.cache.getOpacity(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ);
                boolean botRigT = this.cache.getOpacity(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ);
                int lmcCen = this.cache.getLightmapCoord(dirX2, dirY2, dirZ2);
                int lmcTop = topT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                int lmcBot = botT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                int lmcLef = lefT ? lmcCen : this.cache.getLightmapCoord(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                int n = lmcRig = rigT ? lmcCen : this.cache.getLightmapCoord(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                int n2 = topT && lefT ? lmcLef : (lmcTopLef = topLefT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ));
                int n3 = botT && lefT ? lmcLef : (lmcBotLef = botLefT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ));
                int n4 = topT && rigT ? lmcRig : (lmcTopRig = topRigT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ));
                int lmcBotRig = botT && rigT ? lmcRig : (botRigT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ));
                this.lightmapCoordTopLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcTop, lmcTopLef);
                this.lightmapCoordTopRight = LightmapHelper.avg(lmcCen, lmcRig, lmcTop, lmcTopRig);
                this.lightmapCoordBottomLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcBot, lmcBotLef);
                this.lightmapCoordBottomRight = LightmapHelper.avg(lmcCen, lmcRig, lmcBot, lmcBotRig);
            } else {
                int lmc = !isFullCube ? block.getLightmapCoord(worldSource, tilePos) : block.getLightmapCoord(worldSource, tilePos.add(dirX, dirY, dirZ, new TilePos()));
                this.lightmapCoordBottomRight = this.lightmapCoordTopRight = lmc;
                this.lightmapCoordBottomLeft = this.lightmapCoordTopRight;
                this.lightmapCoordTopLeft = this.lightmapCoordTopRight;
            }
        }
        if (this.overbright) {
            lightTR = 1.0f;
            lightBR = 1.0f;
            lightBL = 1.0f;
            lightTL = 1.0f;
        } else if (ao) {
            float dirB = this.cache.getBrightness(dirX, dirY, dirZ);
            lefT = this.cache.getOpacity(dirX + lefX, dirY + lefY, dirZ + lefZ);
            boolean botT = this.cache.getOpacity(dirX - topX, dirY - topY, dirZ - topZ);
            boolean topT = this.cache.getOpacity(dirX + topX, dirY + topY, dirZ + topZ);
            boolean rigT = this.cache.getOpacity(dirX - lefX, dirY - lefY, dirZ - lefZ);
            float lB = this.cache.getBrightness(dirX + lefX, dirY + lefY, dirZ + lefZ);
            float bB = this.cache.getBrightness(dirX - topX, dirY - topY, dirZ - topZ);
            float tB = this.cache.getBrightness(dirX + topX, dirY + topY, dirZ + topZ);
            float rB = this.cache.getBrightness(dirX - lefX, dirY - lefY, dirZ - lefZ);
            float blB = botT && lefT ? lB : this.cache.getBrightness(dirX + lefX - topX, dirY + lefY - topY, dirZ + lefZ - topZ);
            float tlB = topT && lefT ? lB : this.cache.getBrightness(dirX + lefX + topX, dirY + lefY + topY, dirZ + lefZ + topZ);
            float brB = botT && rigT ? rB : this.cache.getBrightness(dirX - lefX - topX, dirY - lefY - topY, dirZ - lefZ - topZ);
            float trB = topT && rigT ? rB : this.cache.getBrightness(dirX - lefX + topX, dirY - lefY + topY, dirZ - lefZ + topZ);
            lightTL = (tlB + lB + tB + dirB) / 4.0f;
            lightTR = (tB + dirB + trB + rB) / 4.0f;
            lightBR = (dirB + bB + rB + brB) / 4.0f;
            lightBL = (lB + blB + dirB + bB) / 4.0f;
            if (!isFullCube) {
                dirB = this.cache.getBrightness(0, 0, 0);
                lefT = this.cache.getOpacity(lefX, lefY, lefZ);
                botT = this.cache.getOpacity(-topX, -topY, -topZ);
                topT = this.cache.getOpacity(topX, topY, topZ);
                rigT = this.cache.getOpacity(-lefX, -lefY, -lefZ);
                lB = this.cache.getBrightness(lefX, lefY, lefZ);
                bB = this.cache.getBrightness(-topX, -topY, -topZ);
                tB = this.cache.getBrightness(topX, topY, topZ);
                rB = this.cache.getBrightness(-lefX, -lefY, -lefZ);
                blB = botT && lefT ? lB : this.cache.getBrightness(lefX - topX, lefY - topY, lefZ - topZ);
                tlB = topT && lefT ? lB : this.cache.getBrightness(lefX + topX, lefY + topY, lefZ + topZ);
                brB = botT && rigT ? rB : this.cache.getBrightness(-lefX - topX, -lefY - topY, -lefZ - topZ);
                trB = topT && rigT ? rB : this.cache.getBrightness(-lefX + topX, -lefY + topY, -lefZ + topZ);
                lightTL = (tlB + lB + tB + dirB) / 4.0f * depth + lightTL * (1.0f - depth);
                lightTR = (tB + dirB + trB + rB) / 4.0f * depth + lightTR * (1.0f - depth);
                lightBR = (dirB + bB + rB + brB) / 4.0f * depth + lightBR * (1.0f - depth);
                lightBL = (lB + blB + dirB + bB) / 4.0f * depth + lightBL * (1.0f - depth);
            }
        } else {
            float brightness;
            int dirX2 = dirX;
            int dirY2 = dirY;
            int dirZ2 = dirZ;
            if (!isFullCube) {
                dirX2 = 0;
                dirY2 = 0;
                dirZ2 = 0;
            }
            lightBR = lightTR = (brightness = this.cache.getBrightness(dirX2, dirY2, dirZ2));
            lightBL = lightTR;
            lightTL = lightTR;
        }
        if (this.overbright || !BlockModel.ENABLE_DIRECTIONAL_LIGHTING) {
            this.colorRedBottomRight = this.colorRedTopRight = r;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = g;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = b;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
        } else {
            this.colorRedBottomRight = this.colorRedTopRight = r * BlockModel.SIDE_LIGHT_MULTIPLIER[side.getId()];
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = g * BlockModel.SIDE_LIGHT_MULTIPLIER[side.getId()];
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = b * BlockModel.SIDE_LIGHT_MULTIPLIER[side.getId()];
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
        }
        float tl = topP * lightTL + (1.0f - topP) * lightBL;
        float tr = topP * lightTR + (1.0f - topP) * lightBR;
        float bl2 = botP * lightTL + (1.0f - botP) * lightBL;
        float br = botP * lightTR + (1.0f - botP) * lightBR;
        float ltl = lefP * tl + (1.0f - lefP) * tr;
        float lbl = lefP * bl2 + (1.0f - lefP) * br;
        float lbr = rigP * bl2 + (1.0f - rigP) * br;
        float ltr = rigP * tl + (1.0f - rigP) * tr;
        this.colorRedTopLeft *= ltl;
        this.colorGreenTopLeft *= ltl;
        this.colorBlueTopLeft *= ltl;
        this.colorRedBottomLeft *= lbl;
        this.colorGreenBottomLeft *= lbl;
        this.colorBlueBottomLeft *= lbl;
        this.colorRedBottomRight *= lbr;
        this.colorGreenBottomRight *= lbr;
        this.colorBlueBottomRight *= lbr;
        this.colorRedTopRight *= ltr;
        this.colorGreenTopRight *= ltr;
        this.colorBlueTopRight *= ltr;
    }

    public void renderBottomFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderBottomFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderBottomFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(bounds.minX());
        double d4 = tex.getSubIconU(bounds.maxX());
        double d5 = tex.getSubIconV(bounds.minZ());
        double d6 = tex.getSubIconV(bounds.maxZ());
        if (bounds.minX() < 0.0 || bounds.maxX() > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (bounds.minZ() < 0.0 || bounds.maxZ() > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = tex.getSubIconU(bounds.minZ());
            d5 = tex.getSubIconV(1.0 - bounds.maxX());
            d4 = tex.getSubIconU(bounds.maxZ());
            d6 = tex.getSubIconV(1.0 - bounds.minX());
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = tex.getSubIconU(1.0 - bounds.maxZ());
            d5 = tex.getSubIconV(bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.minZ());
            d6 = tex.getSubIconV(bounds.maxX());
            d7 = d4;
            d8 = d3;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = tex.getSubIconU(1.0 - bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.maxX());
            d5 = tex.getSubIconV(1.0 - bounds.minZ());
            d6 = tex.getSubIconV(1.0 - bounds.maxZ());
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + bounds.minX();
        double d12 = x + bounds.maxX();
        double d13 = y + bounds.minY();
        double d14 = z + bounds.minZ();
        double d15 = z + bounds.maxZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        } else {
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        }
    }

    public void renderTopFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderTopFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderTopFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(bounds.minX());
        double d4 = tex.getSubIconU(bounds.maxX());
        double d5 = tex.getSubIconV(bounds.minZ());
        double d6 = tex.getSubIconV(bounds.maxZ());
        if (bounds.minX() < 0.0 || bounds.maxX() > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (bounds.minZ() < 0.0 || bounds.maxZ() > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = tex.getSubIconU(bounds.minZ());
            d5 = tex.getSubIconV(1.0 - bounds.maxX());
            d4 = tex.getSubIconU(bounds.maxZ());
            d6 = tex.getSubIconV(1.0 - bounds.minX());
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = tex.getSubIconU(1.0 - bounds.maxZ());
            d5 = tex.getSubIconV(bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.minZ());
            d6 = tex.getSubIconV(bounds.maxX());
            d7 = d4;
            d8 = d3;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = tex.getSubIconU(1.0 - bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.maxX());
            d5 = tex.getSubIconV(1.0 - bounds.minZ());
            d6 = tex.getSubIconV(1.0 - bounds.maxZ());
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + bounds.minX();
        double d12 = x + bounds.maxX();
        double d13 = y + bounds.maxY();
        double d14 = z + bounds.minZ();
        double d15 = z + bounds.maxZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        }
    }

    public void renderNorthFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderNorthFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderNorthFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(bounds.minX());
        double d4 = tex.getSubIconU(bounds.maxX());
        double d5 = tex.getSubIconV(1.0 - bounds.maxY());
        double d6 = tex.getSubIconV(1.0 - bounds.minY());
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (bounds.minX() < 0.0 || bounds.maxX() > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (bounds.minY() < 0.0 || bounds.maxY() > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateEast == 2) {
            d3 = tex.getSubIconU(bounds.minY());
            d5 = tex.getSubIconV(1.0 - bounds.minX());
            d4 = tex.getSubIconU(bounds.maxY());
            d6 = tex.getSubIconV(1.0 - bounds.maxX());
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateEast == 1) {
            d3 = tex.getSubIconU(1.0 - bounds.maxY());
            d5 = tex.getSubIconV(bounds.maxX());
            d4 = tex.getSubIconU(1.0 - bounds.minY());
            d6 = tex.getSubIconV(bounds.minX());
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = tex.getSubIconU(1.0 - bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.maxX());
            d5 = tex.getSubIconV(bounds.maxY());
            d6 = tex.getSubIconV(bounds.minY());
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + bounds.minX();
        double d13 = x + bounds.maxX();
        double d14 = y + bounds.minY();
        double d15 = y + bounds.maxY();
        double d16 = z + bounds.minZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        }
    }

    public void renderSouthFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderSouthFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderSouthFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(bounds.minX());
        double d4 = tex.getSubIconU(bounds.maxX());
        double d5 = tex.getSubIconV(1.0 - bounds.maxY());
        double d6 = tex.getSubIconV(1.0 - bounds.minY());
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (bounds.minX() < 0.0 || bounds.maxX() > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (bounds.minY() < 0.0 || bounds.maxY() > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateWest == 1) {
            d3 = tex.getSubIconU(bounds.minY());
            d6 = tex.getSubIconV(1.0 - bounds.minX());
            d4 = tex.getSubIconU(bounds.maxY());
            d10 = d5 = tex.getSubIconV(1.0 - bounds.maxX());
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateWest == 2) {
            d3 = tex.getSubIconU(1.0 - bounds.maxY());
            d5 = tex.getSubIconV(bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.minY());
            d6 = tex.getSubIconV(bounds.maxX());
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = tex.getSubIconU(1.0 - bounds.minX());
            d4 = tex.getSubIconU(1.0 - bounds.maxX());
            d5 = tex.getSubIconV(bounds.maxY());
            d6 = tex.getSubIconV(bounds.minY());
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double x0 = x + bounds.minX();
        double x1 = x + bounds.maxX();
        double y0 = y + bounds.minY();
        double y1 = y + bounds.maxY();
        double z0 = z + bounds.maxZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(x0, y1, z0, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(x0, y0, z0, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(x1, y0, z0, d4, d6);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(x1, y1, z0, d8, d10);
        } else {
            tessellator.addVertexWithUV(x0, y1, z0, d3, d5);
            tessellator.addVertexWithUV(x0, y0, z0, d9, d11);
            tessellator.addVertexWithUV(x1, y0, z0, d4, d6);
            tessellator.addVertexWithUV(x1, y1, z0, d8, d10);
        }
    }

    public void renderWestFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderWestFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderWestFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(bounds.minZ());
        double d4 = tex.getSubIconU(bounds.maxZ());
        double d5 = tex.getSubIconV(1.0 - bounds.maxY());
        double d6 = tex.getSubIconV(1.0 - bounds.minY());
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (bounds.minZ() < 0.0 || bounds.maxZ() > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (bounds.minY() < 0.0 || bounds.maxY() > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = tex.getSubIconU(bounds.minY());
            d5 = tex.getSubIconV(1.0 - bounds.maxZ());
            d4 = tex.getSubIconU(bounds.maxY());
            d6 = tex.getSubIconV(1.0 - bounds.minZ());
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateNorth == 2) {
            d3 = tex.getSubIconU(1.0 - bounds.maxY());
            d5 = tex.getSubIconV(bounds.minZ());
            d4 = tex.getSubIconU(1.0 - bounds.minY());
            d6 = tex.getSubIconV(bounds.maxZ());
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = tex.getSubIconU(1.0 - bounds.minZ());
            d4 = tex.getSubIconU(1.0 - bounds.maxZ());
            d5 = tex.getSubIconV(bounds.maxY());
            d6 = tex.getSubIconV(bounds.minY());
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + bounds.minX();
        double d13 = y + bounds.minY();
        double d14 = y + bounds.maxY();
        double d15 = z + bounds.minZ();
        double d16 = z + bounds.maxZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        }
    }

    public void renderEastFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @Nullable IconCoordinate tex) {
        this.renderEastFace(tessellator, bounds, tilePos.x(), tilePos.y(), tilePos.z(), tex);
    }

    public void renderEastFace(@NotNull Tessellator tessellator, @NotNull AABBdc bounds, double x, double y, double z, @Nullable IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double uMin = tex.getSubIconU(bounds.minZ());
        double uMax = tex.getSubIconU(bounds.maxZ());
        double vMin = tex.getSubIconV(1.0 - bounds.maxY());
        double vMax = tex.getSubIconV(1.0 - bounds.minY());
        if (this.flipTexture) {
            double _uMin = uMin;
            uMin = uMax;
            uMax = _uMin;
        }
        if (bounds.minZ() < 0.0 || bounds.maxZ() > 1.0) {
            uMin = tex.getIconUMin();
            uMax = tex.getIconUMax();
        }
        if (bounds.minY() < 0.0 || bounds.maxY() > 1.0) {
            vMin = tex.getIconVMin();
            vMax = tex.getIconVMax();
        }
        double uMax2 = uMax;
        double uMin2 = uMin;
        double vMin2 = vMin;
        double vMax2 = vMax;
        if (this.uvRotateSouth == 2) {
            uMin = tex.getSubIconU(bounds.minY());
            vMin = tex.getSubIconV(1.0 - bounds.minZ());
            uMax = tex.getSubIconU(bounds.maxY());
            vMax = tex.getSubIconV(1.0 - bounds.maxZ());
            vMin2 = vMin;
            vMax2 = vMax;
            uMax2 = uMin;
            uMin2 = uMax;
            vMin = vMax;
            vMax = vMin2;
        } else if (this.uvRotateSouth == 1) {
            uMin = tex.getSubIconU(1.0 - bounds.maxY());
            vMin = tex.getSubIconV(bounds.maxZ());
            uMax = tex.getSubIconU(1.0 - bounds.minY());
            vMax = tex.getSubIconV(bounds.minZ());
            uMax2 = uMax;
            uMin2 = uMin;
            uMin = uMax2;
            uMax = uMin2;
            vMin2 = vMax;
            vMax2 = vMin;
        } else if (this.uvRotateSouth == 3) {
            uMin = tex.getSubIconU(1.0 - bounds.minZ());
            uMax = tex.getSubIconU(1.0 - bounds.maxZ());
            vMin = tex.getSubIconV(bounds.maxY());
            vMax = tex.getSubIconV(bounds.minY());
            uMax2 = uMax;
            uMin2 = uMin;
            vMin2 = vMin;
            vMax2 = vMax;
        }
        double xMax = x + bounds.maxX();
        double yMin = y + bounds.minY();
        double yMax = y + bounds.maxY();
        double zMin = z + bounds.minZ();
        double zMax = z + bounds.maxZ();
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        } else {
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        }
    }
}

