/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ParticleBlockBreaking
extends Particle {
    private final Block<?> block;
    private final Side side;

    public ParticleBlockBreaking(World world, double x, double y, double z, double xa, double ya, double za, Block<?> block, Side side, int meta) {
        super(world, x, y, z, xa, ya, za);
        this.side = side;
        this.block = block;
        this.tex = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getParticleTexture(this.side, meta);
        this.gravity = block != null ? block.blockParticleGravity : 0.0f;
        this.bCol = 0.6f;
        this.gCol = 0.6f;
        this.rCol = 0.6f;
        this.size /= 2.0f;
    }

    public ParticleBlockBreaking init(@NotNull TilePos tilePos) {
        int meta = this.world.getBlockData(tilePos);
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        int index = model.particleColorIndex(this.world, tilePos, this.side, meta);
        if (index >= 0) {
            int col = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(this.world, tilePos, index);
            this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
            this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
            this.bCol *= (float)(col & 0xFF) / 255.0f;
        }
        return this;
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmap(partialTick));
        } else if (!Global.accessor.isFullbrightEnabled()) {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }
}

