/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileArrowGolden;
import net.minecraft.core.entity.projectile.ProjectileArrowPurple;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBow
extends Item {
    public ItemBow(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.setMaxDamage(384);
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        ItemStack quiverSlot = player.getItemInArmorSlot(HumanArmorShape.CHEST);
        if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER.id && quiverSlot.getMetadata() < quiverSlot.getMaxDamage()) {
            quiverSlot.damageItem(1, player);
            selfStack.damageItem(1, player);
            world.playSoundAtEntity(player, player, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ProjectileArrow(world, player, true, 0));
            }
        } else if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER_GOLD.id) {
            selfStack.damageItem(1, player);
            world.playSoundAtEntity(player, player, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ProjectileArrowPurple(world, player, false));
            }
        } else if (player.inventory.consumeInventoryItem(Items.AMMO_ARROW_GOLD.id)) {
            selfStack.damageItem(1, player);
            world.playSoundAtEntity(player, player, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ProjectileArrowGolden(world, player, true));
            }
        } else if (player.inventory.consumeInventoryItem(Items.AMMO_ARROW.id)) {
            selfStack.damageItem(1, player);
            world.playSoundAtEntity(player, player, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                world.entityJoinedWorld(new ProjectileArrow(world, player, true, 0));
            }
        }
        return selfStack;
    }
}

