/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;

public class FloatOptionComponent
extends ButtonComponent {
    protected final OptionFloat option;
    protected final SliderElement slider;
    protected final float minValue;
    protected final float maxValue;

    public FloatOptionComponent(OptionFloat option) {
        this(option, 0.0f, 1.0f, null);
    }

    public FloatOptionComponent(OptionFloat option, float minValue, float maxValue) {
        this(option, minValue, maxValue, null);
    }

    public FloatOptionComponent(OptionFloat option, @Nullable String tooltipTranslationKey) {
        this(option, 0.0f, 1.0f, tooltipTranslationKey);
    }

    public FloatOptionComponent(OptionFloat option, float minValue, float maxValue, @Nullable String tooltipTranslationKey) {
        super("options." + option.name, tooltipTranslationKey);
        this.option = option;
        this.option.addCallback(__ -> this.onChanged());
        this.slider = new SliderElement(0, 0, 0, 150, 20, this.option.getDisplayStringValue(), ((Float)this.option.value).floatValue());
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.option.set(Float.valueOf((float)MathHelper.lerp((double)this.minValue, (double)this.maxValue, this.slider.sliderValue)));
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.option.set(Float.valueOf((float)MathHelper.lerp((double)this.minValue, (double)this.maxValue, this.slider.sliderValue)));
        this.slider.mouseDragged(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.option.set(Float.valueOf((float)MathHelper.lerp((double)this.minValue, (double)this.maxValue, this.slider.sliderValue)));
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            FloatOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void resetValue() {
        this.option.set((Float)this.option.getDefaultValue());
        this.slider.sliderValue = MathHelper.unlerp(this.minValue, this.maxValue, ((Float)this.option.value).floatValue());
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    public void init(Minecraft mc) {
        this.slider.sliderValue = MathHelper.unlerp(this.minValue, this.maxValue, ((Float)this.option.value).floatValue());
        this.onChanged();
    }

    protected void onChanged() {
        this.slider.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public boolean isDefault() {
        float diff = Math.abs(((Float)this.option.value).floatValue() - ((Float)this.option.getDefaultValue()).floatValue());
        return diff < 1.0E-4f;
    }
}

