/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleRedstoneDust
extends Particle {
    private final float oSize;
    private int brightness = -1;

    public ParticleRedstoneDust(World world, double x, double y, double z, int brightness) {
        this(world, x, y, z, 1.0f, brightness);
    }

    public ParticleRedstoneDust(World world, double x, double y, double z, float scale, int brightness) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        if (brightness >= 0) {
            this.brightness = brightness;
        }
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        float n = (float)Math.random() * 0.4f + 0.6f;
        Color color = Colors.allRedstoneColors[MathHelper.clamp(brightness, 0, Colors.allRedstoneColors.length)];
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        this.rCol = ((float)(Math.random() * 0.2) + 0.8f) * red * n;
        this.gCol = ((float)(Math.random() * 0.2) + 0.8f) * green * n;
        this.bCol = ((float)(Math.random() * 0.2) + 0.8f) * blue * n;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int xTile = MathHelper.floor(this.x);
            int yTile = MathHelper.floor(this.y);
            int zTile = MathHelper.floor(this.z);
            int lmc = this.brightness >= 0 ? LightmapHelper.getLightmapCoord(this.world.getSavedLightValue(LightLayer.Sky, xTile, yTile, zTile), Math.max(this.world.getSavedLightValue(LightLayer.Block, xTile, yTile, zTile), this.brightness)) : this.getLightmap(partialTick);
            t.setLightmapCoord(lmc);
        } else {
            br = Math.max(this.getBrightness(partialTick), (float)this.brightness / 15.0f);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin(), this.tex.getIconVMin(), this.tex.getIconUSize(), this.tex.getIconVSize());
    }

    @Override
    public void tick() {
        int val;
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = (val = 7 - this.age * 8 / this.lifetime) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

