/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicCropsPumpkin
extends BlockLogicFlower
implements IBonemealable {
    public BlockLogicCropsPumpkin(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int meta = source.getBlockData(tilePos);
        float onePix = 0.0625f;
        float size = 0.0f;
        if (meta == 0) {
            size = 0.375f;
        } else if (meta == 1) {
            size = 0.5f;
        } else if (meta == 2) {
            size = 0.625f;
        } else if (meta == 3) {
            size = 0.75f;
        } else if (meta == 4) {
            size = 0.875f;
        }
        return new AABBd(0.5f - size / 2.0f, 0.0, 0.5f - size / 2.0f, 0.5f + size / 2.0f, size, 0.5f + size / 2.0f);
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.FARMLAND_DIRT.id();
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        float f;
        int meta;
        super.updateTick(world, tilePos, rand, isRandomTick);
        if (world.getBlockLightValue(tilePos.up(new TilePos())) >= 9 && (meta = world.getBlockData(tilePos)) < 6 && rand.nextInt((int)(100.0f / (f = this.getGrowthRate(world, tilePos)))) == 0) {
            if (++meta == 5) {
                world.setBlockIdDataNotify(tilePos, Blocks.PUMPKIN.id(), 0);
            } else {
                world.setBlockDataNotify(tilePos, meta);
            }
        }
    }

    private float getGrowthRate(@NotNull World world, @NotNull TilePosc tilePos) {
        float growthRate = 1.0f;
        @NotNull TilePos localPos = new TilePos(tilePos);
        @NotNull TilePos queryPos = new TilePos();
        localPos.x = tilePos.x() - 1;
        while (localPos.x <= tilePos.x() + 1) {
            localPos.z = tilePos.z() - 1;
            while (localPos.z <= tilePos.z() + 1) {
                int id = world.getBlockId(localPos.down(queryPos));
                float growthRateMod = 0.0f;
                if (id == Blocks.FARMLAND_DIRT.id()) {
                    growthRateMod = 1.0f;
                    if (world.getBlockData(localPos.down(queryPos)) > 0) {
                        growthRateMod = 3.0f;
                    }
                }
                if (!localPos.equals(tilePos)) {
                    growthRateMod /= 4.0f;
                }
                growthRate += growthRateMod;
                ++localPos.z;
            }
            ++localPos.x;
        }
        boolean isFertilized = BlockLogicFarmland.isFertilized(world.getBlockData(tilePos.down(queryPos)));
        if (!isFertilized) {
            if (world.getSeasonManager().getCurrentSeason() != null) {
                growthRate *= world.getSeasonManager().getCurrentSeason().cropGrowthFactor;
            }
        } else {
            growthRate *= 1.5f;
        }
        return growthRate;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.SEEDS_PUMPKIN, 1)};
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int meta = source.getBlockData(tilePos);
        if (meta == 0) {
            return null;
        }
        return this.getBoundsFromState(source, tilePos).translate(tilePos.x(), tilePos.y(), tilePos.z(), new AABBd());
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if (world.getBlockData(tilePos) < 5) {
            if (!world.isClientSide) {
                world.setBlockIdNotify(tilePos, Blocks.PUMPKIN.id());
                if (player == null || player.getGamemode().consumeBlocks()) {
                    --itemStack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

