/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLog;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.data.gamerule.TreecapitatorHelper;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ItemToolAxe
extends ItemTool {
    public ItemToolAxe(@NotNull String name, @NotNull String namespaceId, int id, @NotNull ToolMaterial toolMaterial) {
        super(name, namespaceId, id, 3, toolMaterial, BlockTags.MINEABLE_BY_AXE);
    }

    @Override
    public boolean canHarvestBlock(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Block<?> block) {
        return block.hasTag(BlockTags.MINEABLE_BY_AXE);
    }

    @Override
    public boolean beforeBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player, @NotNull Block<?> block, @NotNull TilePos blockPos, @NotNull Side side) {
        int id;
        if (!world.isClientSide && world.getGameRuleValue(GameRules.TREECAPITATOR).booleanValue() && !player.isSneaking() && Block.hasLogicClass(Blocks.getBlock(id = world.getBlockId(blockPos)), BlockLogicLog.class)) {
            return !new TreecapitatorHelper(world, blockPos.x, blockPos.y, blockPos.z, player).chopTree();
        }
        return true;
    }
}

