/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.discord;

import com.mojang.logging.LogUtils;
import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.activity.Activity;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.discord.DownloadNativeLibrary;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.slf4j.Logger;

public class RichPresenceHandlerThread
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final long clientId = 896803609696677898L;
    private Core core;
    private final Minecraft minecraft;
    private Instant startTime;
    private boolean hasRegistered = false;
    private static final Map<Dimension, String> dimensionNamesMap = new HashMap<Dimension, String>();
    private static final Map<Biome, String> biomeNamesMap;
    private static final Map<Weather, String> weatherNamesMap;

    public RichPresenceHandlerThread(Minecraft mc) {
        this.minecraft = mc;
    }

    @Override
    public void run() {
        File discordLibrary;
        try {
            discordLibrary = DownloadNativeLibrary.downloadDiscordLibrary();
        }
        catch (IOException e) {
            LOGGER.warn("Error downloading Discord SDK.", e);
            return;
        }
        if (discordLibrary == null) {
            LOGGER.warn("Error downloading Discord SDK.");
            return;
        }
        Core.init(discordLibrary);
        this.startTime = Instant.now();
        this.updateActivity();
        int counter = 0;
        while (true) {
            if (this.core != null) {
                if (!this.hasRegistered) {
                    this.core.activityManager().registerCommand("e");
                    this.hasRegistered = true;
                }
                this.core.runCallbacks();
            }
            try {
                Thread.sleep(16L);
                if (++counter < 256) continue;
                counter = 0;
                this.updateActivity();
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Unexpected Interrupt!", e);
                continue;
            }
            break;
        }
    }

    private void updateActivity() {
        if (!((Boolean)this.minecraft.gameSettings.discordRichPresence.value).booleanValue()) {
            if (this.core != null) {
                this.destroyCore();
            }
        } else if (this.core == null) {
            this.createCore();
        }
        if (this.core == null) {
            return;
        }
        Activity activity = new Activity();
        activity.assets().setLargeImage("bta-logo");
        activity.timestamps().setStart(this.startTime);
        if (this.minecraft.currentWorld == null) {
            activity.setState("In the main menu");
        } else if (this.minecraft.thePlayer != null) {
            if (this.minecraft.thePlayer instanceof PlayerLocalMultiplayer) {
                activity.setDetails("Multiplayer");
                int playerCount = ((PlayerLocalMultiplayer)this.minecraft.thePlayer).sendQueue.players.size();
                activity.party().size().setCurrentSize(playerCount);
                activity.party().size().setMaxSize(100);
            } else if (this.minecraft.currentScreen instanceof ScreenPause) {
                activity.setDetails("Singleplayer (paused)");
            } else {
                activity.setDetails("Singleplayer");
            }
            Dimension activeDimension = (Dimension)Dimension.getDimensionList().get(this.minecraft.thePlayer.dimension);
            Biome biome = this.minecraft.currentWorld.getBlockBiome((int)this.minecraft.thePlayer.x, (int)this.minecraft.thePlayer.y, (int)this.minecraft.thePlayer.z);
            Weather weather = this.minecraft.currentWorld.getCurrentWeather();
            boolean displayDimension = activeDimension != null && dimensionNamesMap.containsKey(activeDimension);
            boolean displayBiome = biome != null && biomeNamesMap.containsKey(biome);
            boolean displayWeather = weather != null && weatherNamesMap.containsKey(weather);
            StringBuilder stateString = new StringBuilder();
            if (displayDimension) {
                stateString.append("In ").append(dimensionNamesMap.get(activeDimension));
            } else {
                stateString.append("Somewhere else");
            }
            if (displayBiome || displayWeather) {
                stateString.append(", ");
            }
            if (displayBiome) {
                stateString.append("exploring ").append(biomeNamesMap.get(biome));
            }
            if (displayWeather) {
                stateString.append(" ").append(weatherNamesMap.get(weather));
            }
            activity.setState(stateString.toString());
        }
        this.core.activityManager().updateActivity(activity);
    }

    private void createCore() {
        try {
            CreateParams params = new CreateParams();
            params.setClientID(896803609696677898L);
            params.setFlags(CreateParams.Flags.NO_REQUIRE_DISCORD);
            this.core = new Core(params);
        }
        catch (GameSDKException sdkException) {
            this.core = null;
        }
    }

    private void destroyCore() {
        this.core.close();
        this.core = null;
    }

    static {
        dimensionNamesMap.put(Dimension.OVERWORLD, "the Overworld");
        dimensionNamesMap.put(Dimension.NETHER, "the Nether");
        dimensionNamesMap.put(Dimension.DRIFT, "the Drift");
        biomeNamesMap = new HashMap<Biome, String>();
        biomeNamesMap.put(Biomes.OVERWORLD_RAINFOREST, "a rainforest");
        biomeNamesMap.put(Biomes.OVERWORLD_SWAMPLAND, "the swamplands");
        biomeNamesMap.put(Biomes.OVERWORLD_SEASONAL_FOREST, "a seasonal forest");
        biomeNamesMap.put(Biomes.OVERWORLD_FOREST, "a forest");
        biomeNamesMap.put(Biomes.OVERWORLD_GRASSLANDS, "the grasslands");
        biomeNamesMap.put(Biomes.OVERWORLD_OUTBACK, "the outback");
        biomeNamesMap.put(Biomes.OVERWORLD_SHRUBLAND, "a shrubland");
        biomeNamesMap.put(Biomes.OVERWORLD_TAIGA, "a taiga");
        biomeNamesMap.put(Biomes.OVERWORLD_BOREAL_FOREST, "a boreal forest");
        biomeNamesMap.put(Biomes.OVERWORLD_DESERT, "a desert");
        biomeNamesMap.put(Biomes.OVERWORLD_PLAINS, "the plains");
        biomeNamesMap.put(Biomes.OVERWORLD_GLACIER, "a glacier");
        biomeNamesMap.put(Biomes.OVERWORLD_TUNDRA, "a tundra");
        biomeNamesMap.put(Biomes.OVERWORLD_MEADOW, "a meadow");
        biomeNamesMap.put(Biomes.NETHER_NETHER, "Hell itself");
        biomeNamesMap.put(Biomes.DRIFT_DRIFT, "the skies");
        biomeNamesMap.put(Biomes.OVERWORLD_BIRCH_FOREST, "a birch forest");
        biomeNamesMap.put(Biomes.OVERWORLD_RETRO, "a world long forgotten");
        biomeNamesMap.put(Biomes.OVERWORLD_HELL, "a ruined world");
        biomeNamesMap.put(Biomes.OVERWORLD_SWAMPLAND_MUDDY, "the swamplands");
        biomeNamesMap.put(Biomes.OVERWORLD_OUTBACK_GRASSY, "the outback");
        biomeNamesMap.put(Biomes.OVERWORLD_CAATINGA, "the caatinga");
        biomeNamesMap.put(Biomes.OVERWORLD_CAATINGA_PLAINS, "the caatinga");
        weatherNamesMap = new HashMap<Weather, String>();
        weatherNamesMap.put(Weathers.OVERWORLD_RAIN, "in the rain");
        weatherNamesMap.put(Weathers.OVERWORLD_SNOW, "in the snow");
        weatherNamesMap.put(Weathers.OVERWORLD_STORM, "in a storm");
        weatherNamesMap.put(Weathers.OVERWORLD_FOG, "in thick fog");
        weatherNamesMap.put(Weathers.OVERWORLD_WINTER_SNOW, "in an endless snowstorm");
    }
}

