/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import java.util.Random;
import net.minecraft.client.render.block.color.BlockColorCustom;
import net.minecraft.client.render.colorizer.Colorizer;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.noise.ImprovedNoise;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockColorTallGrass
extends BlockColorCustom {
    protected static ImprovedNoise grassColorPerlin = new ImprovedNoise(new Random(0L));

    public BlockColorTallGrass(@NotNull Colorizer colorizer) {
        super(colorizer);
    }

    @Override
    public int getWorldColor(@NotNull WorldSource source, @NotNull TilePosc tilePos, int tintIndex) {
        double localTemperature = source.getBlockTemperature(tilePos);
        double localHumidity = source.getBlockHumidity(tilePos);
        long l1 = (long)tilePos.x() * 3129871L + (long)tilePos.z() * 6129781L + (long)tilePos.y();
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        int xO = (int)((long)tilePos.x() + (l1 >> 14 & 0x1FL));
        int yO = (int)((long)tilePos.y() + (l1 >> 19 & 0x1FL));
        int zO = (int)((long)tilePos.z() + (l1 >> 24 & 0x1FL));
        float offsetT = (float)grassColorPerlin.getValue((double)xO / 32.0, (double)yO / 32.0, (double)tilePos.z() / 32.0) / 2.5f;
        float offsetH = (float)grassColorPerlin.getValue((double)tilePos.x() / 32.0, (double)yO / 32.0, (double)zO / 32.0) / 2.5f;
        return Colorizers.grass.getColor(localTemperature += (double)offsetT, localHumidity += (double)offsetH);
    }
}

