/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class BlockModelBed<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate underTexture = TextureRegistry.getTexture("minecraft:block/bed/bottom");
    protected final IconCoordinate[] bedTextures = new IconCoordinate[6];

    public BlockModelBed(Block<T> block) {
        super(block);
        this.bedTextures[0] = TextureRegistry.getTexture("minecraft:block/bed/foot_front");
        this.bedTextures[1] = TextureRegistry.getTexture("minecraft:block/bed/foot_side");
        this.bedTextures[2] = TextureRegistry.getTexture("minecraft:block/bed/foot_top");
        this.bedTextures[3] = TextureRegistry.getTexture("minecraft:block/bed/head_front");
        this.bedTextures[4] = TextureRegistry.getTexture("minecraft:block/bed/head_side");
        this.bedTextures[5] = TextureRegistry.getTexture("minecraft:block/bed/head_top");
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int f17;
        TilePos queryPos = new TilePos();
        AABBd bounds = new AABBd(this.block.getBoundsFromState(worldSource, tilePos));
        BlockModelBed.renderBlocks.enableAO = true;
        BlockModelBed.renderBlocks.cache.setupCache(this.block, worldSource, tilePos);
        int meta = worldSource.getBlockData(tilePos);
        int direction = BlockLogicBed.getDirection(meta);
        boolean isFootOfBed = BlockLogicBed.isBlockFootOfBed(meta);
        double minY = bounds.minY;
        bounds.minY += 0.1875;
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.BOTTOM, meta);
        bounds.minY = minY;
        if (direction == 0) {
            BlockModelBed.renderBlocks.uvRotateTop = 1;
        } else if (direction == 2) {
            BlockModelBed.renderBlocks.uvRotateTop = 2;
        } else if (direction == 1) {
            BlockModelBed.renderBlocks.uvRotateTop = 3;
        }
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.TOP, meta);
        BlockModelBed.renderBlocks.uvRotateTop = 0;
        int n = f17 = isFootOfBed ? BlockLogicBed.headOfBedMap[BlockLogicBed.footToHeadMap[direction]] : BlockLogicBed.headOfBedMap[direction];
        if (f17 != 2 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(worldSource, bounds, tilePos.north(queryPos), Side.NORTH))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 3;
            renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.NORTH, meta);
        }
        if (f17 != 3 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(worldSource, bounds, tilePos.south(queryPos), Side.SOUTH))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 1;
            renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.SOUTH, meta);
        }
        if (f17 != 4 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(worldSource, bounds, tilePos.west(queryPos), Side.WEST))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 2;
            renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.WEST, meta);
        }
        if (f17 != 5 && (BlockModelBed.renderBlocks.renderAllFaces || this.shouldSideBeRendered(worldSource, bounds, tilePos.east(queryPos), Side.EAST))) {
            BlockModelBed.renderBlocks.flipTexture = direction == 0;
            renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.EAST, meta);
        }
        renderBlocks.resetRenderBlocks();
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (side == Side.BOTTOM) {
            return this.underTexture;
        }
        int k = BlockLogicBed.getDirection(data);
        int l = BlockLogicBed.bedDirection[k][side.getId()];
        if (BlockLogicBed.isBlockFootOfBed(data)) {
            if (l == 2) {
                return this.bedTextures[3];
            }
            if (l == 5 || l == 4) {
                return this.bedTextures[4];
            }
            return this.bedTextures[5];
        }
        if (l == 3) {
            return this.bedTextures[0];
        }
        if (l == 5 || l == 4) {
            return this.bedTextures[1];
        }
        return this.bedTextures[2];
    }
}

