/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockModelLeaves<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static boolean fancyGraphics;
    protected final IconCoordinate fancyLeavesTexture;
    protected final boolean canBeRetro;
    protected final IconCoordinate retroLeaves = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro");
    protected final IconCoordinate retroLeavesFancy = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro_fancy");

    public BlockModelLeaves(Block<T> block, String leavesTex) {
        this(block, leavesTex, false);
    }

    public BlockModelLeaves(Block<T> block, String leavesTex, boolean canBeRetro) {
        super(block);
        this.setAllTextures(0, leavesTex);
        this.fancyLeavesTexture = TextureRegistry.getTexture(leavesTex + "_fancy");
        this.canBeRetro = canBeRetro;
    }

    public static void setGraphicsLevel(boolean graphicsLevel) {
        fancyGraphics = graphicsLevel;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        boolean invTint = BlockModelLeaves.renderBlocks.useInventoryTint;
        BlockModelLeaves.renderBlocks.useInventoryTint = !this.canBeRetro || !this.isRetro();
        super.renderStandalone(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        BlockModelLeaves.renderBlocks.useInventoryTint = invTint;
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        if (this.canBeRetro && this.isRetro()) {
            return renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos, 1.0f, 1.0f, 1.0f);
        }
        return super.render(tessellator, worldSource, tilePos);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (this.canBeRetro && this.isRetro()) {
            return fancyGraphics ? this.retroLeavesFancy : this.retroLeaves;
        }
        return fancyGraphics ? this.fancyLeavesTexture : super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (!fancyGraphics && source.getBlockId(tilePos) == this.block.id()) {
            return false;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

