/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.core.Global;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleSlimeChunk
extends Particle {
    public ParticleSlimeChunk(World world, double x, double y, double z, Item item) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.tex = ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack());
        this.gravity = 2.0f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.size /= 2.0f;
        this.lifetime = 50;
    }

    @Override
    public int getParticleTexture() {
        return 2;
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmap(partialTick));
        } else if (!Global.accessor.isFullbrightEnabled()) {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }
}

