/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.Framebuffer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderGeometry;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderExternal;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.tessellator.ShaderParticleTessellator;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.material.Materials;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class ShadersRenderer
implements Renderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    protected final int vao;
    protected final Framebuffer worldFramebuffer = new Framebuffer();
    protected final Texture worldFramebufferTex = new Texture();
    protected final Texture worldFramebufferDepth = new Texture();
    protected final Framebuffer gameFramebuffer = new Framebuffer();
    protected final Texture gameFramebufferTex = new Texture();
    protected final Texture gameFramebufferDepth = new Texture();
    protected final Shader postShader = new Shader();
    protected final Shader finalShader = new Shader();
    protected final Shader cloudsShader = new Shader();
    protected final ShaderGeometry particleShader = new ShaderGeometry();
    protected ShaderProvider internal = new ShaderProviderInternal("/shaders/");
    public ShaderParticleTessellator shaderParticleTessellator = new ShaderParticleTessellator(200000);
    public int fbWidth;
    public int fbHeight;
    public int renderWidth;
    public int renderHeight;
    protected FloatBuffer matrixBuffer = MemoryUtil.memAllocFloat(16);
    protected Matrix4f matrix = new Matrix4f();

    public ShadersRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        if (!Shaders.enableShaders) {
            throw new RuntimeException("Shaders disabled!");
        }
        if (OpenGLHelper.gl32) {
            this.vao = GL30.glGenVertexArrays();
            this.particleShader.supported = true;
            LOGGER.info("GL32 supported, enabling particle geometry shaders");
        } else {
            this.vao = 0;
            this.particleShader.supported = false;
            LOGGER.info("GL32 not supported, disabling particle geometry shaders");
        }
    }

    @Override
    public void beginRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre begin render game");
        this.setupFramebuffer();
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
        GL20.glUseProgram(0);
        GL20.glViewport(0, 0, this.fbWidth, this.fbHeight);
        OpenGLHelper.checkError("begin render game");
    }

    @Override
    public void endRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre end render game");
        GL20.glViewport(0, 0, this.fbWidth, this.fbHeight);
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        if (this.finalShader.isEnabled()) {
            this.finalShader.bind();
            ARBMultitexture.glActiveTextureARB(33984);
            this.gameFramebufferTex.bind();
            this.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.mc, this.finalShader, partialTicks);
            Shaders.drawFullscreenRect();
            GL20.glUseProgram(0);
        }
        OpenGLHelper.checkError("end render game");
    }

    @Override
    public void beginRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre begin render world");
        this.setupFramebuffer();
        this.worldFramebuffer.bind();
        GL20.glViewport(0, 0, this.renderWidth, this.renderHeight);
        GL20.glUseProgram(0);
        OpenGLHelper.checkError("begin render world");
    }

    @Override
    public void beginRenderClouds(float partialTicks) {
        if (((Boolean)this.mc.gameSettings.clouds.value).booleanValue() && (Integer)this.mc.gameSettings.fancyGraphics.value == 1 && this.cloudsShader.isEnabled()) {
            OpenGLHelper.checkError("pre setup clouds");
            GL20.glDisable(3008);
            this.cloudsShader.bind();
            this.matrixBuffer.clear();
            GL20.glGetFloatv(2983, this.matrixBuffer);
            this.matrixBuffer.position(0);
            this.matrix.set(this.matrixBuffer);
            this.matrix.invert();
            this.matrixBuffer.clear();
            this.matrix.get(this.matrixBuffer);
            this.matrixBuffer.position(0);
            this.matrixBuffer.limit(16);
            GL20.glUniformMatrix4fv(this.cloudsShader.getUniform("gbufferProjectionInverse"), false, this.matrixBuffer);
            int isEyeInLiquid = CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.LAVA, partialTicks) ? 2 : (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTicks) ? 1 : 0);
            GL20.glUniform1i(this.cloudsShader.getUniform("isEyeInLiquid"), isEyeInLiquid);
            GL20.glUniform1f(this.cloudsShader.getUniform("viewWidth"), this.renderWidth);
            GL20.glUniform1f(this.cloudsShader.getUniform("viewHeight"), this.renderHeight);
            OpenGLHelper.checkError("setup clouds");
        }
    }

    @Override
    public void beginRenderParticles(float partialTick) {
        if (this.particleShader.isEnabled()) {
            OpenGLHelper.checkError("pre enable render particles");
            GL30.glBindVertexArray(this.vao);
            this.particleShader.bind();
            this.matrix.identity();
            GL20.glUniformMatrix4fv(this.particleShader.getUniform("model"), false, this.matrix.get(this.matrixBuffer));
            this.mc.worldRenderer.getViewMatrix(this.matrix, partialTick);
            GL20.glUniformMatrix4fv(this.particleShader.getUniform("view"), false, this.matrix.get(this.matrixBuffer));
            if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                this.matrix.identity();
            } else {
                this.mc.worldRenderer.orientCamera(this.matrix.identity(), partialTick).invert();
            }
            GL20.glUniformMatrix4fv(this.particleShader.getUniform("viewInv"), false, this.matrix.get(this.matrixBuffer));
            this.mc.worldRenderer.getProjectionMatrix(this.matrix, partialTick);
            GL20.glUniformMatrix4fv(this.particleShader.getUniform("projection"), false, this.matrix.get(this.matrixBuffer));
            GL20.glUniform1i(this.particleShader.getUniform("texture0"), 0);
            GL20.glUniform1i(this.particleShader.getUniform("texture1"), 1);
            GL20.glActiveTexture(33985);
            if (LightmapHelper.isLightmapEnabled()) {
                GL20.glBindTexture(3553, LightmapHelper.instance.lightmapTexture);
            } else {
                this.mc.textureManager.loadTexture("/assets/minecraft/textures/environment/lightmap/disabled.png");
            }
            GL20.glActiveTexture(33984);
            OpenGLHelper.checkError("post enable render particles");
        }
    }

    @Override
    @NotNull
    public ParticleTessellator getParticleTessellator() {
        return this.particleShader.isEnabled() ? this.shaderParticleTessellator : Tessellator.instance;
    }

    @Override
    public void endRenderParticles(float partialTicks) {
        if (this.particleShader.isEnabled()) {
            GL20.glUseProgram(0);
            GL30.glBindVertexArray(0);
        }
    }

    @Override
    public void endRenderClouds(float partialTicks) {
        GL20.glUseProgram(0);
        GL20.glEnable(3008);
    }

    @Override
    public void endRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre end render world");
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
        if (this.postShader.isEnabled()) {
            this.postShader.bind();
            ARBMultitexture.glActiveTextureARB(33984);
            this.worldFramebufferTex.bind();
            this.postShader.uniformInt("colortex0", 0);
            ARBMultitexture.glActiveTextureARB(33985);
            this.worldFramebufferDepth.bind();
            this.postShader.uniformInt("depthtex0", 1);
            ARBMultitexture.glActiveTextureARB(33984);
            this.mc.ppm.enabled = true;
            Shaders.setUniforms(this.mc, this.postShader, partialTicks);
            this.mc.ppm.enabled = false;
        } else {
            GL20.glUseProgram(0);
            this.worldFramebufferTex.bind();
        }
        GL20.glViewport(0, 0, this.fbWidth, this.fbHeight);
        Shaders.drawFullscreenRect();
        GL20.glUseProgram(0);
        GL20.glEnable(3008);
        OpenGLHelper.checkError("end render world");
    }

    public void setupFramebuffer() {
        double renderScale = (float)((RenderScale)((Object)this.mc.gameSettings.renderScale.value)).scale;
        int scaledWidth = (int)(renderScale * (double)this.mc.gameWindow.getWidthPixels());
        int scaledHeight = (int)(renderScale * (double)this.mc.gameWindow.getHeightPixels());
        if (this.fbWidth != this.mc.gameWindow.getWidthPixels() || this.fbHeight != this.mc.gameWindow.getHeightPixels() || this.renderWidth != scaledWidth || this.renderHeight != scaledHeight || !this.gameFramebuffer.isGenerated() || !this.worldFramebuffer.isGenerated()) {
            this.worldFramebuffer.generate();
            this.worldFramebufferTex.generate();
            this.worldFramebufferDepth.generate();
            this.gameFramebuffer.generate();
            this.gameFramebufferTex.generate();
            this.gameFramebufferDepth.generate();
            this.fbWidth = this.mc.gameWindow.getWidthPixels();
            this.fbHeight = this.mc.gameWindow.getHeightPixels();
            this.renderWidth = scaledWidth;
            this.renderHeight = scaledHeight;
            boolean filtering = ((RenderScale)((Object)this.mc.gameSettings.renderScale.value)).useLinearFiltering;
            int filterMode = filtering ? 9729 : 9728;
            LOGGER.info("Display: {} x {}, Render: {} x {}", this.fbWidth, this.fbHeight, this.renderWidth, this.renderHeight);
            this.worldFramebuffer.bind();
            this.worldFramebufferTex.bind();
            GL20.glTexImage2D(3553, 0, 6408, this.renderWidth, this.renderHeight, 0, 6408, 5121, (ByteBuffer)null);
            GL20.glTexParameteri(3553, 10241, filterMode);
            GL20.glTexParameteri(3553, 10240, filterMode);
            GL20.glTexParameteri(3553, 10242, 10496);
            GL20.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.worldFramebufferTex.id(), 0);
            this.worldFramebufferDepth.bind();
            GL20.glTexImage2D(3553, 0, 6402, this.renderWidth, this.renderHeight, 0, 6402, 5121, (ByteBuffer)null);
            GL20.glTexParameteri(3553, 10241, filterMode);
            GL20.glTexParameteri(3553, 10240, filterMode);
            GL20.glTexParameteri(3553, 10242, 10496);
            GL20.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.worldFramebufferDepth.id(), 0);
            this.gameFramebuffer.bind();
            this.gameFramebufferTex.bind();
            GL20.glTexImage2D(3553, 0, 6408, this.fbWidth, this.fbHeight, 0, 6408, 5121, (ByteBuffer)null);
            GL20.glTexParameteri(3553, 10241, 9729);
            GL20.glTexParameteri(3553, 10240, 9729);
            GL20.glTexParameteri(3553, 10242, 10496);
            GL20.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.gameFramebufferTex.id(), 0);
            this.gameFramebufferDepth.bind();
            GL20.glTexImage2D(3553, 0, 6402, this.fbWidth, this.fbHeight, 0, 6402, 5121, (ByteBuffer)null);
            GL20.glTexParameteri(3553, 10241, 9729);
            GL20.glTexParameteri(3553, 10240, 9729);
            GL20.glTexParameteri(3553, 10242, 10496);
            GL20.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.gameFramebufferDepth.id(), 0);
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
    }

    @Override
    public void reload() {
        LOGGER.info("Reloading Shaders...");
        GL20.glUseProgram(0);
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        OpenGLHelper.checkError("pre shader reload");
        this.matrixBuffer = MemoryUtil.memAllocFloat(16);
        this.postShader.delete();
        this.finalShader.delete();
        this.cloudsShader.delete();
        this.particleShader.delete();
        ShaderProvider shaderProvider = this.getShader();
        if (shaderProvider != null) {
            this.finalShader.compile(shaderProvider, "base");
            this.postShader.compile(shaderProvider, "post");
            this.cloudsShader.compile(shaderProvider, "clouds");
            this.particleShader.compile(shaderProvider, "particle");
        }
        OpenGLHelper.checkError("shader reload");
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.gameFramebufferDepth.delete();
        this.gameFramebufferTex.delete();
        this.worldFramebuffer.delete();
        this.worldFramebufferDepth.delete();
        this.worldFramebufferTex.delete();
        MemoryUtil.memFree(this.matrixBuffer);
    }

    @Override
    public void create() {
    }

    public ShaderProvider getShader() {
        String override = (String)this.mc.gameSettings.shaderOverride.value;
        if (!override.isEmpty()) {
            return new ShaderProviderExternal(new File(override));
        }
        return this.internal;
    }

    public Texture getWorldFramebufferTex() {
        return this.worldFramebufferTex;
    }

    @Override
    public int getRenderWidth() {
        return this.renderWidth;
    }

    @Override
    public int getRenderHeight() {
        return this.renderHeight;
    }
}

