/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicFarmland
extends BlockLogic
implements IBonemealable {
    public static final int MASK_FERTILIZED = 16;
    public static final int MASK_WET = 15;

    public BlockLogicFarmland(@NotNull Block<?> block) {
        super(block, Materials.DIRT);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        block.withLightBlock(255);
        block.setTicking(true);
    }

    public static boolean isWet(int data) {
        return BlockLogicFarmland.getWet(data) > 0;
    }

    public static int getWet(int data) {
        return data & 0xF;
    }

    public static int setWet(int data, int amount) {
        return amount & 0xF | data & 0xFFFFFFF0;
    }

    public static boolean isFertilized(int data) {
        return (data & 0x10) != 0;
    }

    public static int setFertilized(int data, boolean fertilized) {
        if (fertilized) {
            return data | 0x10;
        }
        return data & 0xFFFFFFEF;
    }

    @Override
    public int tickDelay() {
        return 60;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return new AABBd(tilePos.x(), tilePos.y(), tilePos.z(), tilePos.x() + 1, tilePos.y() + 1, tilePos.z() + 1);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        @NotNull Material material = source.getBlockMaterial(tilePos.up(new TilePos()));
        if (material == Materials.VEGETABLE) {
            return new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return new AABBd(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        if (BlockLogicFarmland.isWet(data)) {
            return new ItemStack[]{new ItemStack(Blocks.MUD)};
        }
        return new ItemStack[]{new ItemStack(Blocks.DIRT)};
    }

    private boolean isCropsNearby(@NotNull World world, @NotNull TilePosc tilePos) {
        boolean radius = false;
        @NotNull TilePos localPos = new TilePos(tilePos);
        localPos.x = tilePos.x() - 0;
        while (localPos.x <= tilePos.x() + 0) {
            localPos.z = tilePos.z() - 0;
            while (localPos.z <= tilePos.z() + 0) {
                if (world.getBlockId(localPos.set(localPos.x, tilePos.y() + 1, localPos.z)) == Blocks.CROPS_WHEAT.id()) {
                    return true;
                }
                ++localPos.z;
            }
            ++localPos.x;
        }
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return side == Side.TOP ? PartialSupport.INSTANCE : FullSupport.INSTANCE;
    }

    private boolean isWaterNearby(@NotNull World world, @NotNull TilePosc tilePos, int range) {
        @NotNull TilePos localPos = new TilePos(tilePos);
        localPos.x = tilePos.x() - range;
        while (localPos.x <= tilePos.x() + range) {
            localPos.y = tilePos.y() - range;
            while (localPos.y <= tilePos.y() + range) {
                localPos.z = tilePos.z() - range;
                while (localPos.z <= tilePos.z() + range) {
                    if (Blocks.hasTag(world.getBlockId(localPos), BlockTags.IS_WATER)) {
                        return true;
                    }
                    ++localPos.z;
                }
                ++localPos.y;
            }
            ++localPos.x;
        }
        return false;
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity walker) {
        if (world.rand.nextInt(4) == 0 && walker instanceof Player) {
            @NotNull Player player = (Player)walker;
            @Nullable ItemStack bootsSlotStack = player.getItemInArmorSlot(HumanArmorShape.BOOTS);
            if (bootsSlotStack != null && bootsSlotStack.getItem() == Items.ARMOR_BOOTS_LEATHER) {
                return;
            }
            if (BlockLogicFarmland.isWet(world.getBlockData(tilePos))) {
                world.setBlockIdNotify(tilePos, Blocks.MUD.id());
            } else {
                world.setBlockIdNotify(tilePos, Blocks.DIRT.id());
            }
        }
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() - world.rand.nextInt(10) + world.rand.nextInt(10));
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        @NotNull Material material = world.getBlockMaterial(tilePos.up(new TilePos()));
        if (material.isSolid() && material != Materials.VEGETABLE) {
            if (BlockLogicFarmland.isWet(world.getBlockData(tilePos))) {
                world.setBlockIdNotify(tilePos, Blocks.MUD.id());
            } else {
                world.setBlockIdNotify(tilePos, Blocks.DIRT.id());
            }
        } else {
            world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() - world.rand.nextInt(10) + world.rand.nextInt(10));
        }
    }

    private boolean canBecomeWet(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.isWaterNearby(world, tilePos, 1)) {
            return true;
        }
        if (this.isWaterNearby(world, tilePos, 4)) {
            @NotNull TilePos localPos = new TilePos(tilePos);
            localPos.x = tilePos.x() - 1;
            while (localPos.x <= tilePos.x() + 1) {
                localPos.y = tilePos.y() - 1;
                while (localPos.y <= tilePos.y() + 1) {
                    localPos.z = tilePos.z() - 1;
                    while (localPos.z <= tilePos.z() + 1) {
                        int bID = world.getBlockId(localPos);
                        if (bID == Blocks.MUD.id() || bID == Blocks.FARMLAND_DIRT.id() && BlockLogicFarmland.isWet(world.getBlockData(localPos))) {
                            return true;
                        }
                        ++localPos.z;
                    }
                    ++localPos.y;
                }
                ++localPos.x;
            }
        }
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (rand.nextInt(2) != 0) {
            world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() - rand.nextInt(10) + rand.nextInt(10));
            return;
        }
        int data = world.getBlockData(tilePos);
        int hydration = BlockLogicFarmland.getWet(data);
        if (this.isWaterNearby(world, tilePos, 4) || world.isBlockBeingRainedOn(tilePos.up(new TilePos()))) {
            if (hydration < 15 && this.canBecomeWet(world, tilePos)) {
                world.setBlockDataNotify(tilePos, BlockLogicFarmland.setWet(data, hydration + 1));
                world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() - rand.nextInt(10) + rand.nextInt(10));
            }
        } else if (hydration > 0) {
            world.setBlockDataNotify(tilePos, BlockLogicFarmland.setWet(data, hydration - 1));
            world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() - rand.nextInt(10) + rand.nextInt(10));
        } else if (!this.isCropsNearby(world, tilePos)) {
            world.setBlockIdNotify(tilePos, Blocks.DIRT.id());
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int data = world.getBlockData(tilePos);
        if (!BlockLogicFarmland.isFertilized(data) && itemStack.consumeItem(player)) {
            world.setBlockDataNotify(tilePos, BlockLogicFarmland.setFertilized(data, true));
            return true;
        }
        return false;
    }
}

