/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicSign
extends BlockLogic
implements IPaintable {
    public static final int MASK_SIDE = 15;
    public static final int SIDE_NORTH = 2;
    public static final int SIDE_SOUTH = 3;
    public static final int SIDE_WEST = 4;
    public static final int SIDE_EAST = 5;
    public final boolean isFreeStanding;

    public BlockLogicSign(@NotNull Block<?> block, boolean isFreeStanding) {
        super(block, Materials.WOOD);
        this.isFreeStanding = isFreeStanding;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
        block.withEntity(TileEntitySign::new);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        if (this.isFreeStanding) {
            return this.getBounds();
        }
        float bottom = 0.28125f;
        float top = 0.78125f;
        float width = 1.0f;
        float thickness = 0.125f;
        return switch (source.getBlockData(tilePos) & 0xF) {
            case 2 -> new AABBd(0.0, bottom, 1.0f - thickness, width, top, 1.0);
            case 3 -> new AABBd(0.0, bottom, 0.0, width, top, thickness);
            case 4 -> new AABBd(1.0f - thickness, bottom, 0.0, 1.0, top, width);
            case 5 -> new AABBd(0.0, bottom, 0.0, thickness, top, width);
            default -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        };
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    @NotNull
    public Side getAttachedSide(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return switch (source.getBlockData(tilePos) & 0xF) {
            case 2 -> Side.SOUTH;
            case 3 -> Side.NORTH;
            case 4 -> Side.EAST;
            case 5 -> Side.WEST;
            default -> Side.NONE;
        };
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        TilePos queryPos = new TilePos();
        boolean isUnstable = false;
        if (this.isFreeStanding) {
            if (!world.getBlockMaterial(tilePos.down(queryPos)).isSolid()) {
                isUnstable = true;
            }
        } else {
            switch (world.getBlockData(tilePos) & 0xF) {
                case 2: {
                    boolean bl;
                    if (!world.getBlockMaterial(tilePos.add(Direction.SOUTH, queryPos)).isSolid()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    boolean bl;
                    if (!world.getBlockMaterial(tilePos.add(Direction.NORTH, queryPos)).isSolid()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    boolean bl;
                    if (!world.getBlockMaterial(tilePos.add(Direction.EAST, queryPos)).isSolid()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    boolean bl;
                    if (!world.getBlockMaterial(tilePos.add(Direction.WEST, queryPos)).isSolid()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = isUnstable = true;
                }
            }
        }
        if (isUnstable) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
        super.onNeighborChanged(world, tilePos, id);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.SIGN)};
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntitySign signEntity = (TileEntitySign)world.getTileEntity(tilePos);
        if (signEntity != null) {
            if (signEntity.isLocked()) {
                return false;
            }
            ItemStack heldItem = player.getHeldItem();
            if (heldItem != null && heldItem.itemID == Items.DUST_GLOWSTONE.id && !signEntity.isGlowing() && heldItem.consumeItem(player)) {
                signEntity.setGlowing(true);
                if (player.getGamemode().consumeBlocks()) {
                    --heldItem.stackSize;
                }
                player.addStat(Achievements.LIGHT_SIGN, 1);
                return true;
            }
            if (heldItem != null && heldItem.itemID == Items.SLIMEBALL.id && heldItem.consumeItem(player)) {
                signEntity.setLocked(true);
                return true;
            }
            if (heldItem != null && (heldItem.itemID == Items.DYE.id || heldItem.itemID == Items.PAINTBRUSH.id)) {
                return false;
            }
            if (signEntity.isEditableBy(player)) {
                player.displaySignEditorScreen(signEntity);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        world.setBlockIdRaw(tilePos, this.isFreeStanding ? Blocks.SIGN_POST_PLANKS_OAK_PAINTED.id() : Blocks.SIGN_WALL_PLANKS_OAK_PAINTED.id());
        world.setBlockDataNotify(tilePos, color.blockMeta << 4 | world.getBlockData(tilePos) & 0xF);
    }
}

