/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import java.util.List;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.paged.Page;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.paged.PageRegistry;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.worldsettings.BooleanGameRuleComponent;
import net.minecraft.client.gui.worldsettings.WorldTypeButtonComponent;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenWorldSettings
extends ScreenPaged {
    @NotNull
    public static final PageRegistry CREATE_WORLD_PAGES = new PageRegistry();
    @NotNull
    public static final Page PAGE_GAME_RULES = CREATE_WORLD_PAGES.register(new Page("gui.world_settings.page.game_rules.title", Items.PAPER.getDefaultStack()));
    @NotNull
    public static final Page PAGE_WORLD_SETTINGS;
    @NotNull
    private final WorldConfiguration worldConfiguration;

    public ScreenWorldSettings(@Nullable Screen parent, @NotNull WorldConfiguration worldConfiguration) {
        super(parent, CREATE_WORLD_PAGES, PAGE_GAME_RULES, "gui.world_settings.label.title", new String[]{"gui.world_settings.button.done"});
        this.worldConfiguration = worldConfiguration;
        List<PageComponent> gameRulesPageComponents = PAGE_GAME_RULES.getComponents();
        for (PageComponent component : gameRulesPageComponents) {
            if (!(component instanceof BooleanGameRuleComponent)) continue;
            ((BooleanGameRuleComponent)component).setGameRuleCollection(worldConfiguration.getGameRuleCollection());
        }
        List<PageComponent> worldSettingsPageComponents = PAGE_WORLD_SETTINGS.getComponents();
        for (PageComponent component : worldSettingsPageComponents) {
            if (!(component instanceof WorldTypeButtonComponent)) continue;
            ((WorldTypeButtonComponent)component).setWorldConfiguration(worldConfiguration);
        }
    }

    static {
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            if (!(gameRule instanceof GameRuleBoolean)) continue;
            PAGE_GAME_RULES.withComponent(new BooleanGameRuleComponent((GameRuleBoolean)gameRule));
        }
        PAGE_WORLD_SETTINGS = CREATE_WORLD_PAGES.register(new Page("gui.world_settings.page.world_settings.title", Items.PAINTBRUSH.getDefaultStack()).withComponent(new WorldTypeButtonComponent("gui.world_settings.label.world_type", null)));
    }
}

