/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public interface ICamera {
    public void tick();

    public void applyGlTransformations();

    public boolean showPlayer();

    public double getX(float var1);

    default public double getX() {
        return this.getX(1.0f);
    }

    public double getY(float var1);

    default public double getY() {
        return this.getY(1.0f);
    }

    public double getZ(float var1);

    default public double getZ() {
        return this.getZ(1.0f);
    }

    @NotNull
    default public TilePos getTilePos(float partialTick) {
        return new TilePos(this.getX(partialTick), this.getY(partialTick), this.getZ(partialTick));
    }

    @NotNull
    default public TilePos getTilePos() {
        return this.getTilePos(1.0f);
    }

    @NotNull
    default public Vector3dc getPosition(float partialTick) {
        return new Vector3d(this.getX(partialTick), this.getY(partialTick), this.getZ(partialTick));
    }

    @NotNull
    default public Vector3dc getPosition() {
        return this.getPosition(1.0f);
    }

    public double getXRot(float var1);

    default public double getXRot() {
        return this.getXRot(1.0f);
    }

    public double getYRot(float var1);

    default public double getYRot() {
        return this.getYRot(1.0f);
    }

    @NotNull
    default public Vector3dc getViewVector(float partialTick) {
        double pitch = Math.toRadians(this.getXRot(partialTick));
        double yaw = Math.toRadians(this.getYRot(partialTick));
        float xzLen = -MathHelper.cos((float)(-pitch));
        float x = MathHelper.sin((float)(-yaw - java.lang.Math.PI));
        float y = MathHelper.sin((float)(-pitch));
        float z = MathHelper.cos((float)(-yaw - java.lang.Math.PI));
        return new Vector3d(x * xzLen, y, z * xzLen);
    }

    @NotNull
    default public Vector3dc getViewVector() {
        return this.getViewVector(1.0f);
    }

    public double getFov();

    @NotNull
    public CameraFrustum getFrustum();

    default public double distanceToSqr(double x, double y, double z, float partialTick) {
        float dx = (float)(this.getX(partialTick) - x);
        float dy = (float)(this.getY(partialTick) - y);
        float dz = (float)(this.getZ(partialTick) - z);
        return dx * dx + dy * dy + dz * dz;
    }

    default public double distanceToSqr(double x, double y, double z) {
        return this.distanceToSqr(x, y, z, 1.0f);
    }

    default public double distanceTo(@NotNull Entity entity, float partialTick) {
        return this.distanceTo(entity.x, entity.y, entity.z, partialTick);
    }

    default public double distanceTo(@NotNull Entity entity) {
        return this.distanceTo(entity, 1.0f);
    }

    default public double distanceTo(double x, double y, double z, float partialTick) {
        return MathHelper.sqrt(this.distanceToSqr(x, y, z, partialTick));
    }

    default public double distanceTo(double x, double y, double z) {
        return this.distanceTo(x, y, z, 1.0f);
    }
}

