/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;

public class ParticleBubble
extends Particle {
    private final boolean needsWater;

    public ParticleBubble(World world, double x, double y, double z, double xa, double ya, double za, boolean needsWater) {
        super(world, x, y, z, xa, ya, za);
        this.needsWater = needsWater;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.tex = TextureRegistry.getTexture("minecraft:particle/bubble");
        this.size *= random.nextFloat() * 0.6f + 0.2f;
        this.xd = xa * 0.2 + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = ya * 0.2 + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = za * 0.2 + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void tick() {
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd += 0.002;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.85;
        this.yd *= 0.85;
        this.zd *= 0.85;
        if (this.needsWater && this.world.getBlockMaterial(new TilePos(this.x, this.y, this.z)) != Materials.WATER) {
            this.remove();
        }
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }
}

