/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.collection;

import java.util.Objects;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespaceID
implements Comparable<NamespaceID>,
CharSequence,
Poolable<NamespaceID> {
    @NotNull
    public static final String DEFAULT_NAMESPACE = "minecraft";
    @NotNull
    private static final ObjectPool<NamespaceID> POOL = new ObjectPool<NamespaceID>(new ObjectPool.PooledObjectFactory<NamespaceID>(){

        @Override
        @NotNull
        public NamespaceID createDefault() {
            return new NamespaceID("default", "value");
        }
    });
    @NotNull
    private String fullString;
    @Nullable
    private String namespace;
    @Nullable
    private String value;

    @Deprecated
    @NotNull
    public static NamespaceID getPermanent(@NotNull String formattedKey) throws HardIllegalArgumentException {
        return new NamespaceID(formattedKey);
    }

    @Deprecated
    @NotNull
    public static NamespaceID getPermanent(@NotNull String namespace, @NotNull String value) {
        return new NamespaceID(namespace, value);
    }

    @Deprecated
    @NotNull
    public static NamespaceID getTemp(@NotNull String formattedKey) throws HardIllegalArgumentException {
        return POOL.get().set(formattedKey);
    }

    @Deprecated
    @NotNull
    public static NamespaceID getTemp(@NotNull String namespace, @NotNull String value) {
        return POOL.get().set(namespace, value);
    }

    @Deprecated
    public static void deinitializePool() {
        POOL.free();
    }

    @Deprecated
    public static void initializePool() {
        POOL.reset();
    }

    @NotNull
    public static NamespaceID fromPool(@NotNull String formattedKey) throws HardIllegalArgumentException {
        return POOL.get().set(formattedKey);
    }

    @NotNull
    public static NamespaceID fromPool(@NotNull String namespace, @NotNull String value) {
        return POOL.get().set(namespace, value);
    }

    NamespaceID(@NotNull String formattedKey) throws HardIllegalArgumentException {
        this.set(formattedKey);
    }

    NamespaceID(@NotNull String namespace, @NotNull String value) {
        this.set(namespace, value);
    }

    @Override
    @NotNull
    public ObjectPool<NamespaceID> getPool() {
        return POOL;
    }

    @Override
    public void set(@NotNull NamespaceID other) {
        this.fullString = other.fullString;
        this.namespace = other.namespace;
        this.value = other.value;
    }

    @NotNull
    private NamespaceID set(@NotNull String formattedKey) throws HardIllegalArgumentException {
        Objects.requireNonNull(formattedKey);
        int firstIndex = formattedKey.indexOf(":");
        if (firstIndex == -1 || firstIndex != formattedKey.lastIndexOf(":") || firstIndex == 0 || firstIndex == formattedKey.length() - 1) {
            throw new HardIllegalArgumentException("Namespace id key must have exactly 1 ':' character in format <namespace>:<value>! " + formattedKey);
        }
        this.fullString = formattedKey;
        this.namespace = null;
        this.value = null;
        return this;
    }

    @NotNull
    private NamespaceID set(@NotNull String namespace, @NotNull String value) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(value);
        if (namespace.contains(":")) {
            throw new IllegalArgumentException("Namespace must not contain a ':', but was provided '" + namespace + "'!");
        }
        if (value.contains(":")) {
            throw new IllegalArgumentException("Value must not contain a ':', but was provided '" + value + "'!");
        }
        this.fullString = namespace + ":" + value;
        this.namespace = namespace;
        this.value = value;
        return this;
    }

    @Deprecated
    @NotNull
    public NamespaceID makePermanent() {
        return (NamespaceID)this.copyUnpooled();
    }

    @NotNull
    public String namespace() {
        if (this.namespace == null) {
            this.namespace = this.fullString.substring(0, this.fullString.indexOf(":"));
        }
        return this.namespace;
    }

    @NotNull
    public String value() {
        if (this.value == null) {
            this.value = this.fullString.substring(this.fullString.indexOf(":") + 1);
        }
        return this.value;
    }

    @Override
    public int length() {
        return this.fullString.length();
    }

    @Override
    public char charAt(int index) {
        return this.fullString.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.fullString.subSequence(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return this.fullString;
    }

    @Override
    public int compareTo(@NotNull NamespaceID o) {
        return this.fullString.compareTo(o.fullString);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceID that = (NamespaceID)o;
        return this.fullString.equals(that.fullString);
    }

    public int hashCode() {
        return this.fullString.hashCode();
    }
}

