/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.models.entity.mojang;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.data.entity.mojang.Bone;
import org.useless.dragonfly.data.entity.mojang.Cube;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;
import org.useless.dragonfly.data.entity.mojang.Face;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class StaticEntityModelMojang
implements StaticEntityModel {
    private static final BoneTransform DUMMY_TRANSFORM = new BoneTransform();
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull BoneTransform> transformMap = new HashMap<String, BoneTransform>();
    @NotNull
    public final @NotNull BoneTransform @NotNull [] transforms;
    @NotNull
    public final @NotNull Bone @NotNull [] bones;
    public final EntityGeometryMojangData data;
    public final double inflation;
    @NotNull
    protected final AABBd visBounds;
    private final double[] uvsBuffer = new double[8];

    public StaticEntityModelMojang(@NotNull EntityGeometryMojangData data, double inflation) {
        this.data = data;
        this.transforms = new BoneTransform[this.data.bones.size()];
        this.bones = new Bone[this.data.bones.size()];
        this.inflation = inflation;
        int i = 0;
        for (Map.Entry<String, Bone> entry : this.data.bones.entrySet()) {
            BoneTransform transform = new BoneTransform();
            this.transformMap.put(entry.getKey(), transform);
            this.transforms[i] = transform;
            this.bones[i] = entry.getValue();
            ++i;
        }
        this.visBounds = new AABBd(this.data.vBoundsOffset[0] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] - this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[0] + this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] + this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] + this.data.vBoundsWidth / 2.0);
    }

    @Override
    public void resetBones() {
        for (int i = 0; i < this.transforms.length; ++i) {
            this.transforms[i].reset();
        }
    }

    @Override
    @NotNull
    public BoneTransform getTransform(@NotNull String boneId) {
        return this.transformMap.getOrDefault(boneId, DUMMY_TRANSFORM);
    }

    @Override
    @NotNull
    public AABBdc visibleBounds() {
        return this.visBounds;
    }

    @Override
    public void translateToBone(@NotNull String boneId) {
        Bone bone = this.data.bones.get(boneId);
        if (bone == null) {
            return;
        }
        this.boneTransform(bone);
        GL11.glTranslated(bone.pivot[0], bone.pivot[1], bone.pivot[2]);
    }

    @Override
    public void render(@NotNull Tessellator tessellator) {
        for (int i = 0; i < this.bones.length; ++i) {
            Bone bone = this.bones[i];
            GL11.glPushMatrix();
            if (!this.boneTransform(bone)) {
                this.renderBone(tessellator, bone);
            }
            GL11.glPopMatrix();
        }
    }

    protected boolean boneTransform(@NotNull Bone bone) {
        Bone parent;
        boolean hidden = false;
        Bone bone2 = parent = bone.parent != null ? this.data.bones.get(bone.parent) : null;
        if (parent != null) {
            hidden |= this.boneTransform(parent);
        }
        BoneTransform transform = this.transformMap.get(bone.name);
        hidden |= !transform.visible;
        GL11.glTranslated(bone.pivot[0], bone.pivot[1], bone.pivot[2]);
        GL11.glTranslated(transform.posX, transform.posY, transform.posZ);
        GL11.glRotated(-(transform.rotZ * (double)MathHelper.RAD_TO_DEG) - bone.rotation[2], 0.0, 0.0, 1.0);
        GL11.glRotated(transform.rotY * (double)MathHelper.RAD_TO_DEG + bone.rotation[1], 0.0, 1.0, 0.0);
        GL11.glRotated(-(transform.rotX * (double)MathHelper.RAD_TO_DEG) - bone.rotation[0], 1.0, 0.0, 0.0);
        GL11.glTranslated(-bone.pivot[0], -bone.pivot[1], -bone.pivot[2]);
        GL11.glScaled(transform.scaleX, transform.scaleY, transform.scaleZ);
        return hidden;
    }

    protected void renderBone(@NotNull Tessellator tessellator, @NotNull Bone bone) {
        tessellator.startDrawingQuads();
        for (Cube cube : bone.cubes) {
            double vMax;
            double vMin;
            double uMax;
            double uMin;
            Face face;
            double minX = cube.origin[0] - (cube.inflate + bone.inflate + this.inflation);
            double minY = cube.origin[1] - (cube.inflate + bone.inflate + this.inflation);
            double minZ = cube.origin[2] - (cube.inflate + bone.inflate + this.inflation);
            double maxX = minX + cube.size[0] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxY = minY + cube.size[1] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxZ = minZ + cube.size[2] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            if (cube.rotation == null) {
                face = cube.faces[Direction.UP.getId()];
                if (face != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMin;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMax;
                    this.uvsBuffer[1] = vMin;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMax;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.DOWN.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.NORTH.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.SOUTH.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMax;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMin;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMin;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMax;
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.WEST.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMax;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMin;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMin;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMax;
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.EAST.getId()]) == null) continue;
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                continue;
            }
            face = cube.faces[Direction.UP.getId()];
            if (face != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMin;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMax;
                this.uvsBuffer[1] = vMin;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMax;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.DOWN.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.NORTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.SOUTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.WEST.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.EAST.getId()]) == null) continue;
            uMin = face.uv[0] / (double)this.data.textureWidth;
            uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
            vMin = face.uv[1] / (double)this.data.textureHeight;
            vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
            this.uvsBuffer[0] = uMin;
            this.uvsBuffer[2] = uMax;
            this.uvsBuffer[4] = uMax;
            this.uvsBuffer[6] = uMin;
            this.uvsBuffer[1] = vMax;
            this.uvsBuffer[3] = vMax;
            this.uvsBuffer[5] = vMin;
            this.uvsBuffer[7] = vMin;
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
        }
        tessellator.draw();
    }

    protected static void addRotatedVertex(@NotNull Tessellator tessellator, double x, double y, double z, double u, double v, double @NotNull [] pivot, double @NotNull [] rotation) {
        double _x = x - pivot[0];
        double _y = y - pivot[1];
        double _z = z - pivot[2];
        float sin = MathHelper.sin((float)(-rotation[0] * (double)MathHelper.DEG_TO_RAD));
        float cos = MathHelper.cos((float)(-rotation[0] * (double)MathHelper.DEG_TO_RAD));
        double nx = _x;
        double ny = _y * (double)cos - _z * (double)sin;
        double nz = _z * (double)cos + _y * (double)sin;
        _x = nx;
        _y = ny;
        _z = nz;
        sin = MathHelper.sin((float)(-rotation[1] * (double)MathHelper.DEG_TO_RAD));
        cos = MathHelper.cos((float)(-rotation[1] * (double)MathHelper.DEG_TO_RAD));
        nx = _x * (double)cos - _z * (double)sin;
        ny = _y;
        nz = _z * (double)cos + _x * (double)sin;
        _x = nx;
        _y = ny;
        _z = nz;
        sin = MathHelper.sin((float)(-rotation[2] * (double)MathHelper.DEG_TO_RAD));
        cos = MathHelper.cos((float)(-rotation[2] * (double)MathHelper.DEG_TO_RAD));
        nx = _x * (double)cos - _y * (double)sin;
        ny = _y * (double)cos + _x * (double)sin;
        nz = _z;
        _x = nx;
        _y = ny;
        _z = nz;
        tessellator.addVertexWithUV(_x + pivot[0], _y + pivot[1], _z + pivot[2], u, v);
    }
}

