/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;

public class HudComponentHotbar
extends HudComponentMovable {
    private static final ItemStack[] PREVIEW_ITEMS = new ItemStack[]{new ItemStack(Blocks.STONE), new ItemStack(Blocks.COBBLE_STONE), new ItemStack(Blocks.BRICK_CLAY), new ItemStack(Blocks.DIRT), new ItemStack(Blocks.PLANKS_OAK), new ItemStack(Blocks.LOG_OAK), new ItemStack(Blocks.LEAVES_OAK), new ItemStack(Blocks.GLASS), new ItemStack(Blocks.SLAB_STONE_POLISHED)};

    public HudComponentHotbar(String key, Layout layout) {
        super(key, 187, 22, layout);
    }

    @Override
    public int getAnchorX(ComponentAnchor anchor) {
        int xAnchor = super.getAnchorX(anchor);
        if (anchor.xPosition == 0.0f) {
            xAnchor += 5;
        } else if (anchor.xPosition == 0.5f) {
            xAnchor += 2;
        }
        return xAnchor;
    }

    @Override
    public boolean isVisible() {
        return HudComponentHotbar.mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        ContainerInventory inv = HudComponentHotbar.mc.thePlayer.inventory;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        hud.drawGuiIcon(x + 5, y, 182, 22, TextureRegistry.getTexture("minecraft:gui/hud/hotbar"));
        int selectedHotbar = (inv.getHotbarOffset() + 27) % 36 / 9;
        IconCoordinate coordinate = TextureRegistry.getTexture("minecraft:gui/hud/hotbar_selector" + selectedHotbar);
        hud.drawGuiIcon(x, y, 6, 22, coordinate);
        GL11.glEnable(2929);
        GL11.glEnable(3042);
        GL11.glEnable(32826);
        Lighting.enableInventoryLight();
        int lastHotbarStart = (HudComponentHotbar.mc.thePlayer.inventory.getHotbarOffset() + 27) % 36;
        int nextHotbarStart = (HudComponentHotbar.mc.thePlayer.inventory.getHotbarOffset() + 9) % 36;
        if ((float)HudComponentHotbar.mc.hotbarSwapAnimationProgress != 0.0f) {
            Scissor.enable(x + 8, y + 3, 176, 16);
            if (HudComponentHotbar.mc.hotbarSwapAnimationProgress > 0) {
                int itemY;
                int itemX;
                int itemIndex;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 - 22 + (int)(22.0f * ((float)HudComponentHotbar.mc.hotbarSwapAnimationProgress - partialTick) / 3.0f);
                    this.renderInventorySlot(mc, itemIndex + lastHotbarStart, itemX, itemY, partialTick);
                }
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 + (int)(22.0f * ((float)HudComponentHotbar.mc.hotbarSwapAnimationProgress - partialTick) / 3.0f);
                    this.renderInventorySlot(mc, itemIndex + HudComponentHotbar.mc.thePlayer.inventory.getHotbarOffset(), itemX, itemY, partialTick);
                }
            } else {
                int itemY;
                int itemX;
                int itemIndex;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 + 22 + (int)(22.0f * ((float)HudComponentHotbar.mc.hotbarSwapAnimationProgress + partialTick) / 3.0f);
                    this.renderInventorySlot(mc, itemIndex + nextHotbarStart, itemX, itemY, partialTick);
                }
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 + (int)(22.0f * ((float)HudComponentHotbar.mc.hotbarSwapAnimationProgress + partialTick) / 3.0f);
                    this.renderInventorySlot(mc, itemIndex + HudComponentHotbar.mc.thePlayer.inventory.getHotbarOffset(), itemX, itemY, partialTick);
                }
            }
        } else {
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            for (int itemIndex = 0; itemIndex < 9; ++itemIndex) {
                int itemX = x + 8 + itemIndex * 20;
                int itemY = y + 3;
                this.renderInventorySlot(mc, itemIndex + HudComponentHotbar.mc.thePlayer.inventory.getHotbarOffset(), itemX, itemY, partialTick);
            }
        }
        Scissor.disable();
        Lighting.disable();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        hud.drawGuiIcon(x + 4 + inv.getCurrentItemIndex() % 9 * 20, y - 1, 24, 24, TextureRegistry.getTexture(HudComponentHotbar.mc.thePlayer.getHeldObject() == null ? "minecraft:gui/hud/hotbar_selection" : "minecraft:gui/hud/hotbar_selection_locked"));
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, 1.0f);
        hud.heldItemTooltipElement.updateAndRender(mc, x + 5 + 91, y - 29);
        GL11.glPopMatrix();
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gui.drawGuiIcon(x + 5, y, 182, 22, TextureRegistry.getTexture("minecraft:gui/hud/hotbar"));
        int selectedHotbar = 3;
        IconCoordinate coordinate = TextureRegistry.getTexture("minecraft:gui/hud/hotbar_selector3");
        gui.drawGuiIcon(x, y, 6, 22, coordinate);
        gui.drawGuiIcon(x + 4, y - 1, 24, 24, TextureRegistry.getTexture("minecraft:gui/hud/hotbar_selection"));
        GL11.glEnable(2929);
        GL11.glEnable(3042);
        GL11.glEnable(32826);
        Lighting.enableInventoryLight();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        for (int itemIndex = 0; itemIndex < 9; ++itemIndex) {
            int itemX = x + 8 + itemIndex * 20;
            int itemY = y + 3;
            this.renderItem(mc, PREVIEW_ITEMS[itemIndex], itemX, itemY);
        }
        Lighting.disable();
    }

    private void renderInventorySlot(Minecraft mc, int itemIndex, int x, int y, float partialTick) {
        ItemStack itemstack = mc.thePlayer.inventory.mainInventory[itemIndex];
        if (itemstack == null) {
            return;
        }
        ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemstack.getItem());
        float animProgress = (float)itemstack.animationsToGo - partialTick;
        if (animProgress > 0.0f) {
            GL11.glPushMatrix();
            float f2 = 1.0f + animProgress / 5.0f;
            GL11.glTranslatef(x + 8, y + 12, 0.0f);
            GL11.glScalef(1.0f / f2, (f2 + 1.0f) / 2.0f, 1.0f);
            GL11.glTranslatef(-(x + 8), -(y + 12), 0.0f);
        }
        itemModel.renderGui(Tessellator.instance, null, itemstack, x, y, 1.0f, 1.0f, partialTick);
        if (animProgress > 0.0f) {
            GL11.glPopMatrix();
        }
        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, mc.font, mc.textureManager, itemstack, x, y, null, 1.0f);
    }

    private void renderItem(Minecraft mc, ItemStack itemStack, int x, int y) {
        ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemStack.getItem());
        itemModel.renderGui(Tessellator.instance, null, itemStack, x, y, 1.0f, 1.0f, 1.0f);
        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, mc.font, mc.textureManager, itemStack, x, y, null, 1.0f);
    }
}

