/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.subtitles.SubtitleTracker;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.sound.SoundRepository;
import org.lwjgl.opengl.GL11;

public class HudComponentSubtitles
extends HudComponentMovable {
    public HudComponentSubtitles(String key, int xSize, int ySize, Layout layout) {
        super(key, xSize, ySize, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentSubtitles.mc.gameSettings.immersiveMode.drawOverlays() && (Boolean)HudComponentSubtitles.mc.gameSettings.subtitles.value != false;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)HudComponentSubtitles.mc.gameSettings.subtitles.value;
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        this.drawChat(hud, new ArrayList<SubtitleTracker.SubtitleEntry>(HudComponentSubtitles.mc.subtitleTracker.entryMap.values()), xSizeScreen, ySizeScreen, partialTick);
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        ArrayList<SubtitleTracker.SubtitleEntry> example = new ArrayList<SubtitleTracker.SubtitleEntry>();
        example.add(new SubtitleTracker.SubtitleEntry(SoundRepository.SOUNDS.getSoundEvent("mob.wolf.whine"), 0.0, 0.0, 0.0));
        example.add(new SubtitleTracker.SubtitleEntry(SoundRepository.SOUNDS.getSoundEvent("random.drr"), 0.0, 0.0, 0.0));
        example.add(new SubtitleTracker.SubtitleEntry(SoundRepository.SOUNDS.getSoundEvent("random.bow"), 0.0, 0.0, 0.0));
        this.drawChat(gui, example, xSizeScreen, ySizeScreen, 0.0f);
    }

    public void drawChat(Gui gui, List<SubtitleTracker.SubtitleEntry> subtitleEntries, int xSizeScreen, int ySizeScreen, float partialTick) {
        SubtitleTracker.SubtitleEntry entry;
        int i;
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        int width = this.getXSize();
        int height = this.getYSize();
        int xRight = x + width;
        int yBottom = y + height;
        int messagesToShow = height / 10;
        boolean ignoreFadeout = false;
        int maxMessageWidth = 0;
        for (i = 0; i < subtitleEntries.size() && i < messagesToShow; ++i) {
            int msgWidth;
            entry = subtitleEntries.get(i);
            if (entry.soundEvent == null || (msgWidth = HudComponentSubtitles.mc.font.stringWidth(entry.soundEvent.getSubtitleTranslated())) <= maxMessageWidth) continue;
            maxMessageWidth = msgWidth;
        }
        maxMessageWidth += HudComponentSubtitles.mc.font.stringWidth("<") + HudComponentSubtitles.mc.font.stringWidth(">");
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDisable(3008);
        for (i = 0; i < subtitleEntries.size() && i < messagesToShow; ++i) {
            entry = subtitleEntries.get(i);
            if (entry.soundEvent == null) {
                System.err.println("Null sound event in entry map!");
                continue;
            }
            double fadeAmount = entry.getFadeout();
            fadeAmount = 1.0 - fadeAmount;
            if ((fadeAmount *= 10.0) < 0.0) {
                fadeAmount = 0.0;
            }
            if (fadeAmount > 1.0) {
                fadeAmount = 1.0;
            }
            fadeAmount *= fadeAmount;
            int alpha = (int)(255.0 * fadeAmount);
            if (ignoreFadeout) {
                alpha = 255;
            }
            if (alpha <= 0) continue;
            int xPad = 3;
            int y2 = -i * 9 - 8;
            String subtitle = entry.soundEvent.getSubtitleTranslated();
            if (subtitle == null) continue;
            gui.drawRect(xRight - maxMessageWidth - xPad * 2, yBottom + y2 - 1, xRight, yBottom + y2 + 8, alpha / 2 << 24);
            GL11.glEnable(3042);
            HudComponentSubtitles.mc.font.renderCentered((Tessellator)Tessellator.instance, subtitle, xRight - maxMessageWidth / 2 - xPad, yBottom + y2).setShadow().setColor(0xFFFFFF + (alpha << 24)).call();
            if (HudComponentSubtitles.mc.thePlayer == null) continue;
            double sin = Math.sin(entry.getRelativeAngle(HudComponentSubtitles.mc.thePlayer) + 1.5707963267948966);
            if (sin > 0.7) {
                HudComponentSubtitles.mc.font.render((Tessellator)Tessellator.instance, "<", xRight - maxMessageWidth - xPad, yBottom + y2).setColor(0xFFFFFF + (alpha << 24)).call();
                continue;
            }
            if (!(sin < -0.7)) continue;
            HudComponentSubtitles.mc.font.render((Tessellator)Tessellator.instance, ">", xRight - HudComponentSubtitles.mc.font.stringWidth(">") - xPad / 2, yBottom + y2).setColor(0xFFFFFF + (alpha << 24)).call();
        }
        GL11.glEnable(3008);
        GL11.glDisable(3042);
    }
}

