/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;

public class ButtonComponent
extends InteractivePopupComponent<Integer> {
    @NotNull
    private final Minecraft minecraft = Minecraft.getMinecraft();
    @NotNull
    private final String buttonLabel;
    @NotNull
    private final @NotNull String @NotNull [] buttonValues;
    @NotNull
    private final ButtonElement button;
    private int value;

    public ButtonComponent(int width, @NotNull String buttonLabel, @NotNull @NotNull String @NotNull [] buttonValues, int defaultValue) {
        super(width);
        this.buttonLabel = buttonLabel;
        this.buttonValues = buttonValues;
        this.value = defaultValue;
        this.button = new ButtonElement(0, 0, 0, width, this.getHeight(), this.getButtonLabel());
    }

    @NotNull
    private String getButtonLabel() {
        return I18n.getInstance().translateKeyAndFormat(this.buttonLabel, I18n.getInstance().translateKey(this.buttonValues[this.value]));
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        this.button.xPosition = x;
        this.button.yPosition = y;
        this.button.drawButton(this.minecraft, mouseX, mouseY);
    }

    @Override
    public void onClick(int x, int y, int button) {
        if (this.button.mouseClicked(this.minecraft, x, y)) {
            this.value = (this.value + 1) % this.buttonValues.length;
            this.button.displayString = this.getButtonLabel();
        }
    }

    @Override
    @NotNull
    public Integer getOutput() {
        return this.value;
    }
}

