/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.render.tileentity.TileEntityRendererFlag;
import net.minecraft.client.render.tileentity.TileEntityRendererFlowerJar;
import net.minecraft.client.render.tileentity.TileEntityRendererJarButterfly;
import net.minecraft.client.render.tileentity.TileEntityRendererMeshGold;
import net.minecraft.client.render.tileentity.TileEntityRendererMobSpawner;
import net.minecraft.client.render.tileentity.TileEntityRendererMovingPiston;
import net.minecraft.client.render.tileentity.TileEntityRendererSign;
import net.minecraft.client.render.tileentity.TileEntityRendererStatue;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.entity.TileEntityJarButterfly;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public final class TileEntityRenderDispatcher {
    @NotNull
    public static final TileEntityRenderDispatcher instance = new TileEntityRenderDispatcher();
    public static double renderPosX = 0.0;
    public static double renderPosY = 0.0;
    public static double renderPosZ = 0.0;
    @NotNull
    private final @NotNull Map<@NotNull Class<? extends TileEntity>, @Nullable TileEntityRenderer<?>> renderers;
    @NotNull
    public final TextureManager textureManager;
    @NotNull
    public final TexturePackList packList;
    @NotNull
    private final FontRenderer font;
    @NotNull
    public final GameSettings settings;
    @Nullable
    public World world;
    @Nullable
    public ICamera camera;
    public float viewLerpYaw = 0.0f;
    public float viewLerpPitch = 0.0f;
    public double viewLerpPosX = 0.0;
    public double viewLerpPosY = 0.0;
    public double viewLerpPosZ = 0.0;

    private TileEntityRenderDispatcher() {
        Minecraft mc = Minecraft.getMinecraft();
        this.textureManager = mc.textureManager;
        this.packList = mc.texturePackList;
        this.font = mc.font;
        this.settings = mc.gameSettings;
        this.renderers = new HashMap();
        this.reload();
    }

    public void reload() {
        this.renderers.clear();
        this.assignRenderer(TileEntitySign.class, new TileEntityRendererSign());
        this.assignRenderer(TileEntityFlag.class, new TileEntityRendererFlag());
        this.assignRenderer(TileEntityMobSpawner.class, new TileEntityRendererMobSpawner());
        this.assignRenderer(TileEntityMovingPistonBlock.class, new TileEntityRendererMovingPiston());
        this.assignRenderer(TileEntityFlowerJar.class, new TileEntityRendererFlowerJar());
        this.assignRenderer(TileEntityJarButterfly.class, new TileEntityRendererJarButterfly());
        this.assignRenderer(TileEntityMeshGold.class, new TileEntityRendererMeshGold());
        this.assignRenderer(TileEntityStatue.class, new TileEntityRendererStatue());
    }

    public <T extends TileEntity> void assignRenderer(Class<? extends T> clazz, TileEntityRenderer<T> renderer) {
        this.renderers.put(clazz, renderer);
        renderer.init(clazz, this);
    }

    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(Class<? extends TileEntity> e) {
        TileEntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != TileEntity.class) {
            r = this.getRenderer((T)((Object)e.getSuperclass()));
            this.renderers.put(e, r);
        }
        return r;
    }

    @Nullable
    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(@Nullable T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        return this.getRenderer((T)((Object)tileEntity.getClass()));
    }

    public <T extends TileEntity> boolean hasRenderer(@NotNull T tileEntity) {
        return this.getRenderer(tileEntity) != null;
    }

    public void cacheActiveRenderInfo(@NotNull World world, @NotNull ICamera camera, float partialTick) {
        if (this.world != world) {
            for (TileEntityRenderer<?> renderer : this.renderers.values()) {
                if (renderer == null) continue;
                renderer.onWorldChanged(world);
            }
        }
        this.world = world;
        this.camera = camera;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = camera.getX(partialTick);
        this.viewLerpPosY = camera.getY(partialTick);
        this.viewLerpPosZ = camera.getZ(partialTick);
    }

    public <T extends TileEntity> void renderTileEntity(@NotNull Tessellator tessellator, ICamera camera, @NotNull T tileEntity, float partialTick) {
        float brightness;
        TileEntityRenderer<T> renderer = instance.getRenderer(tileEntity);
        if (renderer == null) {
            return;
        }
        if (tileEntity.getDistanceFrom(this.viewLerpPosX, this.viewLerpPosY, this.viewLerpPosZ) > 4096.0 * (double)((Float)this.settings.entityRenderDistance.value).floatValue()) {
            return;
        }
        if (!renderer.isVisible(tileEntity, camera, partialTick)) {
            return;
        }
        assert (this.world != null);
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord(this.world.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, 0));
            brightness = 1.0f;
        } else {
            brightness = Global.accessor.isFullbrightEnabled() ? 1.0f : this.world.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        }
        GL11.glColor3f(brightness, brightness, brightness);
        renderer.doRender(tessellator, tileEntity, (double)tileEntity.x - renderPosX, (double)tileEntity.y - renderPosY, (double)tileEntity.z - renderPosZ, partialTick);
    }

    public <T extends TileEntity> void renderTileEntity(@NotNull Tessellator tessellator, @NotNull T tileEntity, double x, double y, double z, float partialTick) {
        TileEntityRenderer<T> renderer = this.getRenderer(tileEntity);
        if (renderer != null) {
            renderer.doRender(tessellator, tileEntity, x, y, z, partialTick);
        }
    }

    public void tick() {
        for (TileEntityRenderer<?> renderer : this.renderers.values()) {
            if (renderer == null) continue;
            renderer.tick();
        }
    }

    @NotNull
    public FontRenderer getFont() {
        return this.font;
    }
}

