/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLeavesCacao;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;

public class BlockModelLeavesCacao<T extends BlockLogic>
extends BlockModelLeaves<T> {
    protected IconCoordinate[] growthStages = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/leaves/cacao_bean_stage0"), TextureRegistry.getTexture("minecraft:block/leaves/cacao_bean_stage1"), TextureRegistry.getTexture("minecraft:block/leaves/cacao_bean_stage2"), TextureRegistry.getTexture("minecraft:block/leaves/cacao_bean_stage3")};

    public BlockModelLeavesCacao(Block<T> block) {
        super(block, "minecraft:block/leaves/cacao");
        assert (this.growthStages.length == 4) : "There must be a texture associated with every cacao bean stage!";
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        super.render(tessellator, worldSource, tilePos);
        AABBdc bounds = this.block.getBounds();
        int growthRate = BlockLogicLeavesCacao.getGrowthRate(worldSource.getBlockData(tilePos));
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lmc = this.block.getLightmapCoord(worldSource, tilePos);
            if (this.block.emission > 0) {
                lmc = LightmapHelper.setBlocklightValue(lmc, 15);
            }
            tessellator.setLightmapCoord(lmc);
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, tilePos);
            if (this.block.emission > 0) {
                brightness = 1.0f;
            }
        }
        float cNorthSouth = 0.8f;
        float cEastWest = 0.6f;
        if (growthRate > 0) {
            BlockModelLeavesCacao.renderBlocks.overrideBlockTexture = this.growthStages[Math.min(growthRate - 1, 3)];
            tessellator.setColorOpaque_F(0.8f * brightness, 0.8f * brightness, 0.8f * brightness);
            renderBlocks.renderNorthFace(tessellator, bounds, tilePos, BlockModelLeavesCacao.renderBlocks.overrideBlockTexture);
            renderBlocks.renderSouthFace(tessellator, bounds, tilePos, BlockModelLeavesCacao.renderBlocks.overrideBlockTexture);
            tessellator.setColorOpaque_F(0.6f * brightness, 0.6f * brightness, 0.6f * brightness);
            renderBlocks.renderEastFace(tessellator, bounds, tilePos, BlockModelLeavesCacao.renderBlocks.overrideBlockTexture);
            renderBlocks.renderWestFace(tessellator, bounds, tilePos, BlockModelLeavesCacao.renderBlocks.overrideBlockTexture);
            BlockModelLeavesCacao.renderBlocks.overrideBlockTexture = null;
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderStandalone(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        AABBdc bounds = this.block.getBounds();
        IconCoordinate cacaoCoord = this.growthStages[3];
        GL11.glColor4f(brightness, brightness, brightness, alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }
}

