/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class BlockModelPiston<T extends BlockLogicPistonBase>
extends BlockModelStandard<T> {
    @NotNull
    private final IconCoordinate faceTexture;
    @NotNull
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston/side");
    @NotNull
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston/top");
    @NotNull
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston/bottom");
    protected final double headThickness;
    private boolean headless = false;

    public BlockModelPiston(Block<T> block, @NotNull IconCoordinate faceTexture) {
        this(block, faceTexture, 0.25);
    }

    public BlockModelPiston(Block<T> block, @NotNull IconCoordinate faceTexture, double headThickness) {
        super(block);
        this.headThickness = headThickness;
        this.faceTexture = faceTexture;
    }

    public BlockModelPiston<T> setPistonTextures(@NotNull IconCoordinate sideTexture, @NotNull IconCoordinate topTexture, @NotNull IconCoordinate bottomTexture) {
        this.sideTexture = sideTexture;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
        return this;
    }

    public BlockModelPiston<T> setPistonTextures(@NotNull String sideTexture, @NotNull String topTexture, @NotNull String bottomTexture) {
        return this.setPistonTextures(TextureRegistry.getTexture(sideTexture), TextureRegistry.getTexture(topTexture), TextureRegistry.getTexture(bottomTexture));
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return this.renderPistonBase(tessellator, worldSource, tilePos, false);
    }

    public boolean renderHeadless(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePos tilePos) {
        BlockModelPiston.renderBlocks.renderAllFaces = true;
        this.headless = true;
        boolean result = this.renderPistonBase(tessellator, worldSource, tilePos, true);
        this.headless = false;
        BlockModelPiston.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean noCulling) {
        int meta = worldSource.getBlockData(tilePos);
        boolean extended = noCulling || (meta & 8) != 0;
        Direction direction = BlockLogicPistonBase.getDirection(meta);
        if (extended) {
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, switch (direction) {
                case Direction.DOWN -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    yield new AABBd(0.0, this.headThickness, 0.0, 1.0, 1.0, 1.0);
                }
                case Direction.UP -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0 - this.headThickness, 1.0);
                case Direction.NORTH -> {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    yield new AABBd(0.0, 0.0, this.headThickness, 1.0, 1.0, 1.0);
                }
                case Direction.SOUTH -> {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    yield new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0 - this.headThickness);
                }
                case Direction.WEST -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    yield new AABBd(this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                case Direction.EAST -> {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                    yield new AABBd(0.0, 0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0);
                }
                default -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }, tilePos);
            renderBlocks.resetRenderBlocks();
        } else {
            switch (direction) {
                case DOWN: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case NORTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case SOUTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case EAST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                }
            }
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBounds(), tilePos);
            renderBlocks.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderStandalone(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    @NotNull
    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        Direction direction = BlockLogicPistonBase.getDirection(data);
        if (direction == Direction.NONE) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (side.getDirection() == direction) {
            if (BlockLogicPistonBase.isPowered(data) || this.headless) {
                return this.topTexture;
            }
            return this.blockTextures.get(Side.BOTTOM);
        }
        return side.getDirection() != direction.getOpposite() ? this.sideTexture : this.bottomTexture;
    }
}

