/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.legacy.SaveFormatLegacy;
import net.minecraft.core.world.save.mcregion.SaveFormat19132;
import net.minecraft.core.world.save.mcregion.SaveFormat19133;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import org.slf4j.Logger;

public class SaveFormats {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Int2ObjectMap<Class<? extends ISaveFormat>> saveFormats = new Int2ObjectArrayMap<Class<? extends ISaveFormat>>();

    public static ISaveFormat createSaveFormat(int version, File savesDir) {
        if (!saveFormats.containsKey(version)) {
            return null;
        }
        try {
            return (ISaveFormat)((Class)saveFormats.get(version)).getConstructor(File.class).newInstance(savesDir);
        }
        catch (Exception e) {
            LOGGER.error("Exception instancing ISaveFormat from '{}'!", (Object)version, (Object)e);
            return null;
        }
    }

    static {
        saveFormats.put(0, (Class<? extends ISaveFormat>)SaveFormatLegacy.class);
        saveFormats.put(19132, (Class<? extends ISaveFormat>)SaveFormat19132.class);
        saveFormats.put(19133, (Class<? extends ISaveFormat>)SaveFormat19133.class);
        saveFormats.put(19134, (Class<? extends ISaveFormat>)SaveFormat19134.class);
    }
}

