#version 330 core
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

in VS_OUT {
    float scale;
    vec4 color;
    vec2 uv;
    vec2 uvSizes;
    vec2 lightmap;
} gs_in[];

out vec4 Color;
out vec2 TexCoord;
out vec2 Lightmap;

uniform mat4 model;
uniform mat4 view;
uniform mat4 viewInv;
uniform mat4 projection;

void main() {
    Color = gs_in[0].color;
    Lightmap = gs_in[0].lightmap;

    TexCoord = gs_in[0].uv;
    gl_Position = projection * view * model * (gl_in[0].gl_Position + viewInv * vec4(-gs_in[0].scale,  gs_in[0].scale, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(0, gs_in[0].uvSizes.y);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + viewInv * vec4(-gs_in[0].scale, -gs_in[0].scale, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(gs_in[0].uvSizes.x, 0);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + viewInv * vec4( gs_in[0].scale,  gs_in[0].scale, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + gs_in[0].uvSizes;
    gl_Position = projection * view * model * (gl_in[0].gl_Position + viewInv * vec4( gs_in[0].scale, -gs_in[0].scale, 0.0, 0.0));
    EmitVertex();

    EndPrimitive();
}