/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuFurnaceBlast;
import org.jetbrains.annotations.NotNull;

public class ScreenFurnaceBlast
extends ScreenContainerAbstract {
    private final TileEntityFurnaceBlast tileEntity;

    public ScreenFurnaceBlast(@NotNull ContainerInventory inventory, @NotNull TileEntityFurnaceBlast tileEntity) {
        super(new MenuFurnaceBlast(inventory, tileEntity));
        this.tileEntity = tileEntity;
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        I18n i18n = I18n.getInstance();
        this.drawStringNoShadow(this.fontRenderer, i18n.translateKey("gui.furnace.blast.label.blast_furnace"), 60, 6, 0x404040);
        this.drawStringNoShadow(this.fontRenderer, i18n.translateKey("gui.furnace.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/blastfurnace.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tileEntity.isBurning()) {
            int fireHeight = this.tileEntity.getBurnTimeRemainingScaled(14);
            this.drawTexturedModalRect(x + 56, y + 35 + 14 - fireHeight, 176, 14 - fireHeight, 14, fireHeight + 2);
            int arrowWidth = this.tileEntity.getCookProgressScaled(24);
            this.drawTexturedModalRect(x + 79, y + 34, 176, 15, arrowWidth + 1, 16);
        }
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        controller.inventoryHandler.handleFurnaceBlast(this);
    }
}

