/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelFluid<T extends BlockLogicFluid>
extends BlockModelStandard<T> {
    public BlockModelFluid(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, tilePos, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        TilePos queryPos = new TilePos();
        int x = tilePos.x();
        int y = tilePos.y();
        int z = tilePos.z();
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        boolean renderTop = this.shouldSideBeRendered(worldSource, bounds, tilePos.up(queryPos), Side.TOP);
        boolean flag1 = this.shouldSideBeRendered(worldSource, bounds, tilePos.down(queryPos), Side.BOTTOM);
        boolean[] aflag = new boolean[]{this.shouldSideBeRendered(worldSource, bounds, tilePos.north(queryPos), Side.NORTH), this.shouldSideBeRendered(worldSource, bounds, tilePos.south(queryPos), Side.SOUTH), this.shouldSideBeRendered(worldSource, bounds, tilePos.west(queryPos), Side.WEST), this.shouldSideBeRendered(worldSource, bounds, tilePos.east(queryPos), Side.EAST)};
        if (!(renderTop || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean didRender = false;
        float sideBottom = 0.5f;
        float sideTop = 1.0f;
        float sideNorthSouth = 0.8f;
        float sideEastWest = 0.6f;
        float yOff = 0.001f;
        int meta = worldSource.getBlockData(tilePos);
        float f7 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos);
        float f8 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(0, 0, 1, queryPos));
        float f9 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(1, 0, 1, queryPos));
        float f10 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(1, 0, 0, queryPos));
        if (BlockModelFluid.renderBlocks.renderAllFaces || renderTop) {
            didRender = true;
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.TOP, meta);
            float rotation = (float)((BlockLogicFluid)this.block.getLogic()).getSlopeAngle(worldSource, tilePos);
            if (rotation > -999.0f) {
                texture = this.getBlockTextureFromSideAndMetadata(Side.NORTH, meta);
            } else {
                rotation = 0.0f;
            }
            float blockBrightness = 1.0f;
            int light = this.block.getLightmapCoord(worldSource, tilePos);
            int lightUp = this.block.getLightmapCoord(worldSource, tilePos.up(queryPos));
            tessellator.setLightmapCoord1i(LightmapHelper.max(light, lightUp));
            if (texture.namespaceId.toString().contains("_flowing")) {
                double centerU = texture.getSubIconU(0.5);
                double centerV = texture.getSubIconV(0.5);
                float cSin = MathHelper.cos(rotation) / 2.0f;
                float sin = MathHelper.sin(rotation) / 2.0f;
                double minU = texture.getIconUMin();
                double maxU = texture.getIconUMax();
                double minV = texture.getIconVMin();
                double maxV = texture.getIconVMax();
                tessellator.setColorOpaque3f(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, (minU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, (maxU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, (maxU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, (minU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
            } else {
                tessellator.setColorOpaque3f(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, texture.getIconUMin(), texture.getIconVMax());
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, texture.getIconUMax(), texture.getIconVMax());
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, texture.getIconUMax(), texture.getIconVMin());
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, texture.getIconUMin(), texture.getIconVMin());
            }
        }
        if (BlockModelFluid.renderBlocks.renderAllFaces || flag1) {
            float brightness = 1.0f;
            tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos.down(queryPos)));
            tessellator.setColorOpaque3f(0.5f * brightness * r, 0.5f * brightness * g, 0.5f * brightness * b);
            renderBlocks.renderBottomFace(tessellator, bounds, x, (float)y + 0.001f, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
            didRender = true;
        }
        TilePos posB = new TilePos(0, 0, 0);
        for (int side = 0; side < 4; ++side) {
            float f21;
            float f19;
            float f20;
            float f17;
            float f15;
            float f13;
            posB.set(x, y, z);
            switch (side) {
                case 0: {
                    posB.set(x, y, z - 1);
                    break;
                }
                case 1: {
                    posB.set(x, y, z + 1);
                    break;
                }
                case 2: {
                    posB.set(x - 1, y, z);
                    break;
                }
                case 3: {
                    posB.set(x + 1, y, z);
                }
            }
            float uOff = side == 0 || side == 1 ? ((x & 1) == 0 ? 0.0f : 0.5f) : ((z & 1) == 0 ? 0.0f : 0.5f);
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.getSideById(side + 2), meta);
            if (!BlockModelFluid.renderBlocks.renderAllFaces && !aflag[side]) continue;
            if (side == 0) {
                f13 = f7;
                f15 = f10;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else if (side == 1) {
                f13 = f9;
                f15 = f8;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)(z + 1) - 0.001f;
            } else if (side == 2) {
                f13 = f8;
                f15 = f7;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else {
                f13 = f10;
                f15 = f9;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)(z + 1) - 1.0E-4f;
            }
            didRender = true;
            float vOff = (y & 1) == 0 ? 0.0f : 0.5f;
            double d4 = texture.getSubIconU(0.0f + uOff);
            double d5 = texture.getSubIconU(0.5f + uOff);
            double d6 = texture.getSubIconV(0.5f - f13 / 2.0f + vOff);
            double d7 = texture.getSubIconV(0.5f - f15 / 2.0f + vOff);
            double d8 = texture.getSubIconV(0.5f + vOff);
            float brightness = 1.0f;
            tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, posB));
            brightness = side < 2 ? (brightness *= 0.8f) : (brightness *= 0.6f);
            tessellator.setColorOpaque3f(1.0f * brightness * r, 1.0f * brightness * g, 1.0f * brightness * b);
            tessellator.addVertexWithUV(f17, (float)y + f13, f19, d4, d6);
            tessellator.addVertexWithUV(f20, (float)y + f15, f21, d5, d7);
            tessellator.addVertexWithUV(f20, y, f21, d5, d8);
            tessellator.addVertexWithUV(f17, y, f19, d4, d8);
        }
        return didRender;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        Material material = source.getBlockMaterial(tilePos);
        if (material == this.block.getMaterial()) {
            return false;
        }
        if (material == Materials.ICE) {
            return true;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

