/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelOverlayLeaves<T extends BlockLogic>
extends BlockModelLeaves<T> {
    protected final IconCoordinate overlayTexture;

    public BlockModelOverlayLeaves(Block<T> block, String leavesTex, String overlayTex) {
        super(block, leavesTex);
        this.overlayTexture = TextureRegistry.getTexture(overlayTex);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        super.render(tessellator, worldSource, tilePos);
        BlockModelOverlayLeaves.renderBlocks.overrideBlockTexture = this.overlayTexture;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsRaw(), tilePos, 1.0f, 1.0f, 1.0f);
        BlockModelOverlayLeaves.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        AABBdc bounds = this.block.getBounds();
        IconCoordinate overlayCoord = this.overlayTexture;
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, overlayCoord);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

