/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public class BlockModelVeryRotatable<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static final DisplayPos ROTATABLE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos ROTATABLE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -180.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos ROTATABLE_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -45.0f, 0.0f, 0.4f, 0.4f, 0.4f);

    public BlockModelVeryRotatable(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", ROTATABLE_GUI);
        this.setDisplayPos("head", ROTATABLE_HEAD);
        this.setDisplayPos("firstperson_righthand", ROTATABLE_FIRST_PERSON_RIGHT_HAND);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        Direction dir = BlockLogicVeryRotatable.metaToDirection(meta);
        if (dir == Direction.DOWN || dir == Direction.UP) {
            BlockModelVeryRotatable.renderBlocks.uvRotateSouth = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateNorth = 2;
            BlockModelVeryRotatable.renderBlocks.uvRotateEast = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateWest = 2;
        } else if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            BlockModelVeryRotatable.renderBlocks.uvRotateTop = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateBottom = 1;
        }
        boolean result = super.render(tessellator, worldSource, tilePos);
        renderBlocks.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        BlockModelVeryRotatable.renderBlocks.uvRotateTop = 1;
        BlockModelVeryRotatable.renderBlocks.uvRotateBottom = 1;
        super.renderStandalone(tessellator, 3, lightmapCoord);
        renderBlocks.resetRenderBlocks();
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(@NotNull Side side, int data) {
        return super.getBlockOverbrightTextureFromSideAndMeta(this.getRotatedSide(side, data), data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        return super.getBlockTextureFromSideAndMetadata(this.getRotatedSide(side, data), data);
    }

    public Side getRotatedSide(Side side, int data) {
        Direction dir = BlockLogicVeryRotatable.metaToDirection(data);
        return switch (dir) {
            case Direction.SOUTH -> side;
            case Direction.EAST -> side.getDirection().rotate(1).getSide();
            case Direction.NORTH -> side.getDirection().rotate(2).getSide();
            case Direction.WEST -> side.getDirection().rotate(3).getSide();
            case Direction.UP -> {
                switch (side) {
                    case NORTH: {
                        yield Side.TOP;
                    }
                    case SOUTH: {
                        yield Side.BOTTOM;
                    }
                    case TOP: {
                        yield Side.SOUTH;
                    }
                    case BOTTOM: {
                        yield Side.NORTH;
                    }
                }
                yield side;
            }
            case Direction.DOWN -> {
                switch (side) {
                    case NORTH: {
                        yield Side.TOP;
                    }
                    case SOUTH: {
                        yield Side.BOTTOM;
                    }
                    case TOP: {
                        yield Side.NORTH;
                    }
                    case BOTTOM: {
                        yield Side.SOUTH;
                    }
                }
                yield side;
            }
            default -> Side.BOTTOM;
        };
    }
}

